
/* Do not modify this file it was automatically generated by the
 * TokenList2DsnLexer CMake script.
 */

#ifndef PCB_LEXER_H_
#define PCB_LEXER_H_

#include <dsnlexer.h>

/**
 * C++ does not put enum _values_ in separate namespaces unless the enum itself
 * is in a separate namespace.  All the token enums must be in separate namespaces
 * otherwise the C++ compiler will eventually complain if it sees more than one
 * DSNLEXER in the same compilation unit, say by multiple header file inclusion.
 * Plus this also enables re-use of the same enum name T.  A typedef can always be used
 * to clarify which enum T is in play should that ever be a problem.  This is
 * unlikely since Parse() functions will usually only be exposed to one header
 * file like this one.  But if there is a problem, then use:
 *   typedef PCB_KEYS_T::T T;
 * within that problem area.
 */
namespace PCB_KEYS_T
{
    /// enum T contains all this lexer's tokens.
    enum T
    {
        // these first few are negative special ones for syntax, and are
        // inherited from DSNLEXER.
        T_NONE          = DSN_NONE,
        T_BAR           = DSN_BAR,          // Also called pipe: '|'
        T_COMMENT       = DSN_COMMENT,
        T_STRING_QUOTE  = DSN_STRING_QUOTE,
        T_QUOTE_DEF     = DSN_QUOTE_DEF,
        T_DASH          = DSN_DASH,
        T_SYMBOL        = DSN_SYMBOL,
        T_NUMBER        = DSN_NUMBER,
        T_RIGHT         = DSN_RIGHT,        // right bracket: ')'
        T_LEFT          = DSN_LEFT,         // left bracket:  '('
        T_STRING        = DSN_STRING,       // a quoted string, stripped of the quotes
        T_EOF           = DSN_EOF,          // special case for end of file

        T_add_net = 0,
        T_addsublayer,
        T_aligned,
        T_allow_missing_courtyard,
        T_allow_soldermask_bridges,
        T_allow_soldermask_bridges_in_footprints,
        T_allow_two_segments,
        T_allowed,
        T_anchor,
        T_angle,
        T_arc,
        T_arc_segments,
        T_area,
        T_arrow1a,
        T_arrow1b,
        T_arrow2a,
        T_arrow2b,
        T_arrow_direction,
        T_arrow_length,
        T_at,
        T_attr,
        T_autoplace_cost180,
        T_autoplace_cost90,
        T_aux_axis_origin,
        T_back,
        T_best_length_ratio,
        T_best_width_ratio,
        T_bevelled,
        T_blind,
        T_blind_buried_vias_allowed,
        T_board_only,
        T_bold,
        T_border,
        T_bottom,
        T_bottom_left,
        T_bottom_right,
        T_castellated_pads,
        T_cells,
        T_center,
        T_chamfer,
        T_chamfer_ratio,
        T_circle,
        T_class,
        T_clearance,
        T_clearance_min,
        T_color,
        T_cols,
        T_column_count,
        T_column_widths,
        T_comment,
        T_company,
        T_component_class,
        T_component_classes,
        T_connect,
        T_connect_pads,
        T_convexhull,
        T_copper_finish,
        T_copper_line_width,
        T_copper_text_dims,
        T_copperpour,
        T_courtyard_line_width,
        T_creepage,
        T_crossbar,
        T_curve_points,
        T_curved_edges,
        T_custom,
        T_data,
        T_date,
        T_defaults,
        T_descr,
        T_die_length,
        T_dielectric_constraints,
        T_diff_pair_gap,
        T_diff_pair_width,
        T_dimension,
        T_dimension_precision,
        T_dimension_units,
        T_dnp,
        T_drawings,
        T_drill,
        T_edge,
        T_edge_clearance,
        T_edge_connector,
        T_edge_cuts_line_width,
        T_edge_plating,
        T_edge_width,
        T_effects,
        T_embedded_files,
        T_embedded_fonts,
        T_enabled,
        T_end,
        T_epsilon_r,
        T_exclude_from_bom,
        T_exclude_from_pos_files,
        T_extension_height,
        T_extension_offset,
        T_external,
        T_fab_layers_line_width,
        T_fab_layers_text_dims,
        T_face,
        T_false,
        T_feature1,
        T_feature2,
        T_fill,
        T_fill_segments,
        T_filled_areas_thickness,
        T_filled_polygon,
        T_fillet,
        T_filter_ratio,
        T_font,
        T_footprint,
        T_footprints,
        T_format,
        T_fp_arc,
        T_fp_circle,
        T_fp_curve,
        T_fp_line,
        T_fp_poly,
        T_fp_rect,
        T_fp_text,
        T_fp_text_box,
        T_free,
        T_front,
        T_front_inner_back,
        T_full,
        T_general,
        T_generated,
        T_generator,
        T_generator_version,
        T_gr_arc,
        T_gr_bbox,
        T_gr_circle,
        T_gr_curve,
        T_gr_line,
        T_gr_poly,
        T_gr_rect,
        T_gr_text,
        T_gr_text_box,
        T_gr_vector,
        T_grid_origin,
        T_group,
        T_hatch,
        T_hatch_border_algorithm,
        T_hatch_gap,
        T_hatch_min_hole_area,
        T_hatch_orientation,
        T_hatch_smoothing_level,
        T_hatch_smoothing_value,
        T_hatch_thickness,
        T_header,
        T_height,
        T_hide,
        T_hole_to_hole_min,
        T_host,
        T_href,
        T_id,
        T_image,
        T_inward,
        T_island,
        T_island_area_min,
        T_island_removal_mode,
        T_italic,
        T_justify,
        T_keep_end_layers,
        T_keep_text_aligned,
        T_keep_upright,
        T_keepout,
        T_kicad_pcb,
        T_knockout,
        T_last_trace_width,
        T_layer,
        T_layers,
        T_leader,
        T_leader_length,
        T_left,
        T_legacy_teardrops,
        T_line_spacing,
        T_linear,
        T_links,
        T_locked,
        T_loss_tangent,
        T_margins,
        T_material,
        T_max_error,
        T_max_length,
        T_max_width,
        T_members,
        T_micro,
        T_mid,
        T_min_thickness,
        T_mirror,
        T_mod_edge_width,
        T_mod_text_size,
        T_mod_text_width,
        T_mode,
        T_model,
        T_module,
        T_name,
        T_net,
        T_net_class,
        T_net_name,
        T_net_tie_pad_groups,
        T_nets,
        T_no,
        T_no_connects,
        T_none,
        T_not_allowed,
        T_np_thru_hole,
        T_offset,
        T_opacity,
        T_options,
        T_orientation,
        T_orthogonal,
        T_other_layers_line_width,
        T_other_layers_text_dims,
        T_outline,
        T_outward,
        T_oval,
        T_override_value,
        T_pad,
        T_pad_drill,
        T_pad_prop_bga,
        T_pad_prop_castellated,
        T_pad_prop_fiducial_glob,
        T_pad_prop_fiducial_loc,
        T_pad_prop_heatsink,
        T_pad_prop_mechanical,
        T_pad_prop_testpoint,
        T_pad_size,
        T_pad_to_mask_clearance,
        T_pad_to_paste_clearance,
        T_pad_to_paste_clearance_ratio,
        T_pads,
        T_padstack,
        T_padvia,
        T_page,
        T_paper,
        T_path,
        T_pcb_text_size,
        T_pcb_text_width,
        T_pcbplotparams,
        T_pinfunction,
        T_pintype,
        T_placed,
        T_placement,
        T_plus,
        T_polygon,
        T_portrait,
        T_precision,
        T_prefer_zone_connections,
        T_prefix,
        T_primitives,
        T_priority,
        T_private_layers,
        T_property,
        T_pts,
        T_radial,
        T_radius,
        T_rect,
        T_rect_delta,
        T_reference,
        T_remove_unused_layers,
        T_render_cache,
        T_rev,
        T_right,
        T_rotate,
        T_roundrect,
        T_roundrect_rratio,
        T_row_heights,
        T_rows,
        T_scale,
        T_segment,
        T_segment_width,
        T_separators,
        T_setup,
        T_shape,
        T_sheetfile,
        T_sheetname,
        T_silk_line_width,
        T_silk_text_dims,
        T_size,
        T_smd,
        T_smoothing,
        T_solder_mask_margin,
        T_solder_mask_min_width,
        T_solder_paste_margin,
        T_solder_paste_margin_ratio,
        T_solder_paste_ratio,
        T_solid,
        T_span,
        T_stackup,
        T_start,
        T_status,
        T_stroke,
        T_style,
        T_suffix,
        T_suppress_zeroes,
        T_table,
        T_table_cell,
        T_tags,
        T_target,
        T_teardrop,
        T_teardrops,
        T_tedit,
        T_tenting,
        T_text_frame,
        T_text_position_mode,
        T_thermal_bridge_angle,
        T_thermal_bridge_width,
        T_thermal_gap,
        T_thermal_width,
        T_thickness,
        T_through_hole,
        T_through_hole_min,
        T_thru,
        T_thru_hole,
        T_thru_hole_only,
        T_title,
        T_title_block,
        T_top,
        T_top_left,
        T_top_right,
        T_trace_clearance,
        T_trace_min,
        T_trace_width,
        T_track_end,
        T_tracks,
        T_trapezoid,
        T_true,
        T_tstamp,
        T_type,
        T_units,
        T_units_format,
        T_unlocked,
        T_user,
        T_user_diff_pair,
        T_user_trace_width,
        T_user_via,
        T_uuid,
        T_uvia_dia,
        T_uvia_drill,
        T_uvia_min_drill,
        T_uvia_min_size,
        T_uvia_size,
        T_uvias_allowed,
        T_value,
        T_version,
        T_via,
        T_via_dia,
        T_via_drill,
        T_via_min_annulus,
        T_via_min_drill,
        T_via_min_size,
        T_via_size,
        T_vias,
        T_virtual,
        T_visible_elements,
        T_width,
        T_x,
        T_xy,
        T_xyz,
        T_yes,
        T_zone,
        T_zone_45_only,
        T_zone_clearance,
        T_zone_connect,
        T_zone_layer_connections,
        T_zone_type,
        T_zones
    };
}   // namespace PCB_KEYS_T


/**
 * Class PCB_LEXER
 * is an automatically generated class using the TokenList2DnsLexer.cmake
 * technology, based on keywords provided by file:
 *    /build/kicad/src/kicad/common/pcb.keywords
 */
class PCB_LEXER : public DSNLEXER
{
    /// Auto generated lexer keywords table and length:
    static const KEYWORD  keywords[];
    static const KEYWORD_MAP keywords_hash;
    static const unsigned keyword_count;

public:
    /**
     * Constructor ( const std::string&, const wxString& )
     * @param aSExpression is (utf8) text possibly from the clipboard that you want to parse.
     * @param aSource is a description of the origin of @a aSExpression, such as a filename.
     *   If left empty, then _("clipboard") is used.
     */
    PCB_LEXER( const std::string& aSExpression, const wxString& aSource = wxEmptyString ) :
        DSNLEXER( keywords, keyword_count, &keywords_hash, aSExpression, aSource )
    {
    }

    /**
     * Constructor ( FILE* )
     * takes @a aFile already opened for reading and @a aFilename as parameters.
     * The opened file is assumed to be positioned at the beginning of the file
     * for purposes of accurate line number reporting in error messages.  The
     * FILE is closed by this instance when its destructor is called.
     * @param aFile is a FILE already opened for reading.
     * @param aFilename is the name of the opened file, needed for error reporting.
     */
    PCB_LEXER( FILE* aFile, const wxString& aFilename ) :
        DSNLEXER( keywords, keyword_count, &keywords_hash, aFile, aFilename )
    {
    }

    /**
     * Constructor ( LINE_READER* )
     * initializes a lexer and prepares to read from @a aLineReader which
     * is assumed ready, and may be in use by other DSNLEXERs also.  No ownership
     * is taken of @a aLineReader. This enables it to be used by other lexers also.
     * The transition between grammars in such a case, must happen on a text
     * line boundary, not within the same line of text.
     *
     * @param aLineReader is any subclassed instance of LINE_READER, such as
     *  STRING_LINE_READER or FILE_LINE_READER.  No ownership is taken of aLineReader.
     */
    PCB_LEXER( LINE_READER* aLineReader ) :
        DSNLEXER( keywords, keyword_count, &keywords_hash, aLineReader )
    {
    }

    /**
     * Function TokenName
     * returns the name of the token in ASCII form.
     */
    static const char* TokenName( PCB_KEYS_T::T aTok );

    /**
     * Function NextTok
     * returns the next token found in the input file or T_EOF when reaching
     * the end of file.  Users should wrap this function to return an enum
     * to aid in grammar debugging while running under a debugger, but leave
     * this lower level function returning an int (so the enum does not collide
     * with another usage).
     * @return PCB_KEYS_T::T - the type of token found next.
     * @throw IO_ERROR - only if the LINE_READER throws it.
     */
    PCB_KEYS_T::T NextTok()
    {
        return (PCB_KEYS_T::T) DSNLEXER::NextTok();
    }

    /**
     * Function NeedSYMBOL
     * calls NextTok() and then verifies that the token read in
     * satisfies bool IsSymbol().
     * If not, an IO_ERROR is thrown.
     * @return int - the actual token read in.
     * @throw IO_ERROR, if the next token does not satisfy IsSymbol()
     */
    PCB_KEYS_T::T NeedSYMBOL()
    {
        return (PCB_KEYS_T::T) DSNLEXER::NeedSYMBOL();
    }

    /**
     * Function NeedSYMBOLorNUMBER
     * calls NextTok() and then verifies that the token read in
     * satisfies bool IsSymbol() or tok==T_NUMBER.
     * If not, an IO_ERROR is thrown.
     * @return int - the actual token read in.
     * @throw IO_ERROR, if the next token does not satisfy the above test
     */
    PCB_KEYS_T::T NeedSYMBOLorNUMBER()
    {
        return (PCB_KEYS_T::T) DSNLEXER::NeedSYMBOLorNUMBER();
    }

    /**
     * Function CurTok
     * returns whatever NextTok() returned the last time it was called.
     */
    PCB_KEYS_T::T CurTok()
    {
        return (PCB_KEYS_T::T) DSNLEXER::CurTok();
    }

    /**
     * Function PrevTok
     * returns whatever NextTok() returned the 2nd to last time it was called.
     */
    PCB_KEYS_T::T PrevTok()
    {
        return (PCB_KEYS_T::T) DSNLEXER::PrevTok();
    }

    /**
     * Function GetCurStrAsToken
     * Used to support 'loose' matches (quoted tokens)
     */
    PCB_KEYS_T::T GetCurStrAsToken()
    {
        return (PCB_KEYS_T::T) DSNLEXER::GetCurStrAsToken();
    }
};

// example usage

/**
 * Class _PARSER
 * holds data and functions pertinent to parsing a S-expression file .
 *
class PCB_PARSER : public PCB_LEXER
{

};
*/

#endif   // PCB_LEXER_H_
