// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "istio.io/client-go/pkg/apis/networking/v1"
	networkingv1 "istio.io/client-go/pkg/applyconfiguration/networking/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeWorkloadEntries implements WorkloadEntryInterface
type FakeWorkloadEntries struct {
	Fake *FakeNetworkingV1
	ns   string
}

var workloadentriesResource = v1.SchemeGroupVersion.WithResource("workloadentries")

var workloadentriesKind = v1.SchemeGroupVersion.WithKind("WorkloadEntry")

// Get takes name of the workloadEntry, and returns the corresponding workloadEntry object, and an error if there is any.
func (c *FakeWorkloadEntries) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.WorkloadEntry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(workloadentriesResource, c.ns, name), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}

// List takes label and field selectors, and returns the list of WorkloadEntries that match those selectors.
func (c *FakeWorkloadEntries) List(ctx context.Context, opts metav1.ListOptions) (result *v1.WorkloadEntryList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(workloadentriesResource, workloadentriesKind, c.ns, opts), &v1.WorkloadEntryList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.WorkloadEntryList{ListMeta: obj.(*v1.WorkloadEntryList).ListMeta}
	for _, item := range obj.(*v1.WorkloadEntryList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested workloadEntries.
func (c *FakeWorkloadEntries) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(workloadentriesResource, c.ns, opts))

}

// Create takes the representation of a workloadEntry and creates it.  Returns the server's representation of the workloadEntry, and an error, if there is any.
func (c *FakeWorkloadEntries) Create(ctx context.Context, workloadEntry *v1.WorkloadEntry, opts metav1.CreateOptions) (result *v1.WorkloadEntry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(workloadentriesResource, c.ns, workloadEntry), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}

// Update takes the representation of a workloadEntry and updates it. Returns the server's representation of the workloadEntry, and an error, if there is any.
func (c *FakeWorkloadEntries) Update(ctx context.Context, workloadEntry *v1.WorkloadEntry, opts metav1.UpdateOptions) (result *v1.WorkloadEntry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(workloadentriesResource, c.ns, workloadEntry), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeWorkloadEntries) UpdateStatus(ctx context.Context, workloadEntry *v1.WorkloadEntry, opts metav1.UpdateOptions) (*v1.WorkloadEntry, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(workloadentriesResource, "status", c.ns, workloadEntry), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}

// Delete takes name of the workloadEntry and deletes it. Returns an error if one occurs.
func (c *FakeWorkloadEntries) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(workloadentriesResource, c.ns, name, opts), &v1.WorkloadEntry{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeWorkloadEntries) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(workloadentriesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.WorkloadEntryList{})
	return err
}

// Patch applies the patch and returns the patched workloadEntry.
func (c *FakeWorkloadEntries) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.WorkloadEntry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workloadentriesResource, c.ns, name, pt, data, subresources...), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied workloadEntry.
func (c *FakeWorkloadEntries) Apply(ctx context.Context, workloadEntry *networkingv1.WorkloadEntryApplyConfiguration, opts metav1.ApplyOptions) (result *v1.WorkloadEntry, err error) {
	if workloadEntry == nil {
		return nil, fmt.Errorf("workloadEntry provided to Apply must not be nil")
	}
	data, err := json.Marshal(workloadEntry)
	if err != nil {
		return nil, err
	}
	name := workloadEntry.Name
	if name == nil {
		return nil, fmt.Errorf("workloadEntry.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workloadentriesResource, c.ns, *name, types.ApplyPatchType, data), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeWorkloadEntries) ApplyStatus(ctx context.Context, workloadEntry *networkingv1.WorkloadEntryApplyConfiguration, opts metav1.ApplyOptions) (result *v1.WorkloadEntry, err error) {
	if workloadEntry == nil {
		return nil, fmt.Errorf("workloadEntry provided to Apply must not be nil")
	}
	data, err := json.Marshal(workloadEntry)
	if err != nil {
		return nil, err
	}
	name := workloadEntry.Name
	if name == nil {
		return nil, fmt.Errorf("workloadEntry.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workloadentriesResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1.WorkloadEntry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.WorkloadEntry), err
}
