{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Allows to enter or change numeric values.
-- 
-- \<picture>
--   \<source srcset=\"spinbutton-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkSpinButton\" src=\"spinbutton.png\">
-- \<\/picture>
-- 
-- Rather than having to directly type a number into a @GtkEntry@,
-- @GtkSpinButton@ allows the user to click on one of two arrows
-- to increment or decrement the displayed value. A value can still be
-- typed in, with the bonus that it can be checked to ensure it is in a
-- given range.
-- 
-- The main properties of a @GtkSpinButton@ are through an adjustment.
-- See the t'GI.Gtk.Objects.Adjustment.Adjustment' documentation for more details about
-- an adjustment\'s properties.
-- 
-- Note that @GtkSpinButton@ will by default make its entry large enough
-- to accommodate the lower and upper bounds of the adjustment. If this
-- is not desired, the automatic sizing can be turned off by explicitly
-- setting [Editable:widthChars]("GI.Gtk.Interfaces.Editable#g:attr:widthChars") to a value != -1.
-- 
-- == Using a GtkSpinButton to get an integer
-- 
-- 
-- === /c code/
-- >// Provides a function to retrieve an integer value from a GtkSpinButton
-- >// and creates a spin button to model percentage values.
-- >
-- >int
-- >grab_int_value (GtkSpinButton *button,
-- >                gpointer       user_data)
-- >{
-- >  return gtk_spin_button_get_value_as_int (button);
-- >}
-- >
-- >void
-- >create_integer_spin_button (void)
-- >{
-- >
-- >  GtkWidget *window, *button;
-- >  GtkAdjustment *adjustment;
-- >
-- >  adjustment = gtk_adjustment_new (50.0, 0.0, 100.0, 1.0, 5.0, 0.0);
-- >
-- >  window = gtk_window_new ();
-- >
-- >  // creates the spinbutton, with no decimal places
-- >  button = gtk_spin_button_new (adjustment, 1.0, 0);
-- >  gtk_window_set_child (GTK_WINDOW (window), button);
-- >
-- >  gtk_window_present (GTK_WINDOW (window));
-- >}
-- 
-- 
-- == Using a GtkSpinButton to get a floating point value
-- 
-- 
-- === /c code/
-- >// Provides a function to retrieve a floating point value from a
-- >// GtkSpinButton, and creates a high precision spin button.
-- >
-- >float
-- >grab_float_value (GtkSpinButton *button,
-- >                  gpointer       user_data)
-- >{
-- >  return gtk_spin_button_get_value (button);
-- >}
-- >
-- >void
-- >create_floating_spin_button (void)
-- >{
-- >  GtkWidget *window, *button;
-- >  GtkAdjustment *adjustment;
-- >
-- >  adjustment = gtk_adjustment_new (2.500, 0.0, 5.0, 0.001, 0.1, 0.0);
-- >
-- >  window = gtk_window_new ();
-- >
-- >  // creates the spinbutton, with three decimal places
-- >  button = gtk_spin_button_new (adjustment, 0.001, 3);
-- >  gtk_window_set_child (GTK_WINDOW (window), button);
-- >
-- >  gtk_window_present (GTK_WINDOW (window));
-- >}
-- 
-- 
-- = Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [SpinButton::changeValue]("GI.Gtk.Objects.SpinButton#g:signal:changeValue")
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >spinbutton.horizontal
-- >├── text
-- >│    ├── undershoot.left
-- >│    ╰── undershoot.right
-- >├── button.down
-- >╰── button.up
-- 
-- 
-- 
-- 	
-- >spinbutton.vertical
-- >├── button.up
-- >├── text
-- >│    ├── undershoot.left
-- >│    ╰── undershoot.right
-- >╰── button.down
-- 
-- 
-- @GtkSpinButton@s main CSS node has the name spinbutton. It creates subnodes
-- for the entry and the two buttons, with these names. The button nodes have
-- the style classes .up and .down. The @GtkText@ subnodes (if present) are put
-- below the text node. The orientation of the spin button is reflected in
-- the .vertical or .horizontal style class on the main node.
-- 
-- = Accessibility
-- 
-- @GtkSpinButton@ uses the 'GI.Gtk.Enums.AccessibleRoleSpinButton' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SpinButton
    ( 

-- * Exported types
    SpinButton(..)                          ,
    IsSpinButton                            ,
    toSpinButton                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [configure]("GI.Gtk.Objects.SpinButton#g:method:configure"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [delegateGetAccessiblePlatformState]("GI.Gtk.Interfaces.Editable#g:method:delegateGetAccessiblePlatformState"), [deleteSelection]("GI.Gtk.Interfaces.Editable#g:method:deleteSelection"), [deleteText]("GI.Gtk.Interfaces.Editable#g:method:deleteText"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [editingDone]("GI.Gtk.Interfaces.CellEditable#g:method:editingDone"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [finishDelegate]("GI.Gtk.Interfaces.Editable#g:method:finishDelegate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initDelegate]("GI.Gtk.Interfaces.Editable#g:method:initDelegate"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertText]("GI.Gtk.Interfaces.Editable#g:method:insertText"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [removeWidget]("GI.Gtk.Interfaces.CellEditable#g:method:removeWidget"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectRegion]("GI.Gtk.Interfaces.Editable#g:method:selectRegion"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [spin]("GI.Gtk.Objects.SpinButton#g:method:spin"), [startEditing]("GI.Gtk.Interfaces.CellEditable#g:method:startEditing"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [update]("GI.Gtk.Objects.SpinButton#g:method:update"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActivatesDefault]("GI.Gtk.Objects.SpinButton#g:method:getActivatesDefault"), [getAdjustment]("GI.Gtk.Objects.SpinButton#g:method:getAdjustment"), [getAlignment]("GI.Gtk.Interfaces.Editable#g:method:getAlignment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChars]("GI.Gtk.Interfaces.Editable#g:method:getChars"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClimbRate]("GI.Gtk.Objects.SpinButton#g:method:getClimbRate"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDelegate]("GI.Gtk.Interfaces.Editable#g:method:getDelegate"), [getDigits]("GI.Gtk.Objects.SpinButton#g:method:getDigits"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEditable]("GI.Gtk.Interfaces.Editable#g:method:getEditable"), [getEnableUndo]("GI.Gtk.Interfaces.Editable#g:method:getEnableUndo"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIncrements]("GI.Gtk.Objects.SpinButton#g:method:getIncrements"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMaxWidthChars]("GI.Gtk.Interfaces.Editable#g:method:getMaxWidthChars"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getNumeric]("GI.Gtk.Objects.SpinButton#g:method:getNumeric"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPosition]("GI.Gtk.Interfaces.Editable#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRange]("GI.Gtk.Objects.SpinButton#g:method:getRange"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectionBounds]("GI.Gtk.Interfaces.Editable#g:method:getSelectionBounds"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getSnapToTicks]("GI.Gtk.Objects.SpinButton#g:method:getSnapToTicks"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getText]("GI.Gtk.Interfaces.Editable#g:method:getText"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUpdatePolicy]("GI.Gtk.Objects.SpinButton#g:method:getUpdatePolicy"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getValue]("GI.Gtk.Objects.SpinButton#g:method:getValue"), [getValueAsInt]("GI.Gtk.Objects.SpinButton#g:method:getValueAsInt"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getWidthChars]("GI.Gtk.Interfaces.Editable#g:method:getWidthChars"), [getWrap]("GI.Gtk.Objects.SpinButton#g:method:getWrap").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActivatesDefault]("GI.Gtk.Objects.SpinButton#g:method:setActivatesDefault"), [setAdjustment]("GI.Gtk.Objects.SpinButton#g:method:setAdjustment"), [setAlignment]("GI.Gtk.Interfaces.Editable#g:method:setAlignment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setClimbRate]("GI.Gtk.Objects.SpinButton#g:method:setClimbRate"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDigits]("GI.Gtk.Objects.SpinButton#g:method:setDigits"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEditable]("GI.Gtk.Interfaces.Editable#g:method:setEditable"), [setEnableUndo]("GI.Gtk.Interfaces.Editable#g:method:setEnableUndo"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIncrements]("GI.Gtk.Objects.SpinButton#g:method:setIncrements"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMaxWidthChars]("GI.Gtk.Interfaces.Editable#g:method:setMaxWidthChars"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setNumeric]("GI.Gtk.Objects.SpinButton#g:method:setNumeric"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPosition]("GI.Gtk.Interfaces.Editable#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRange]("GI.Gtk.Objects.SpinButton#g:method:setRange"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setSnapToTicks]("GI.Gtk.Objects.SpinButton#g:method:setSnapToTicks"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setText]("GI.Gtk.Interfaces.Editable#g:method:setText"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUpdatePolicy]("GI.Gtk.Objects.SpinButton#g:method:setUpdatePolicy"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setValue]("GI.Gtk.Objects.SpinButton#g:method:setValue"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setWidthChars]("GI.Gtk.Interfaces.Editable#g:method:setWidthChars"), [setWrap]("GI.Gtk.Objects.SpinButton#g:method:setWrap").

#if defined(ENABLE_OVERLOADING)
    ResolveSpinButtonMethod                 ,
#endif

-- ** configure #method:configure#

#if defined(ENABLE_OVERLOADING)
    SpinButtonConfigureMethodInfo           ,
#endif
    spinButtonConfigure                     ,


-- ** getActivatesDefault #method:getActivatesDefault#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetActivatesDefaultMethodInfo ,
#endif
    spinButtonGetActivatesDefault           ,


-- ** getAdjustment #method:getAdjustment#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetAdjustmentMethodInfo       ,
#endif
    spinButtonGetAdjustment                 ,


-- ** getClimbRate #method:getClimbRate#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetClimbRateMethodInfo        ,
#endif
    spinButtonGetClimbRate                  ,


-- ** getDigits #method:getDigits#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetDigitsMethodInfo           ,
#endif
    spinButtonGetDigits                     ,


-- ** getIncrements #method:getIncrements#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetIncrementsMethodInfo       ,
#endif
    spinButtonGetIncrements                 ,


-- ** getNumeric #method:getNumeric#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetNumericMethodInfo          ,
#endif
    spinButtonGetNumeric                    ,


-- ** getRange #method:getRange#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetRangeMethodInfo            ,
#endif
    spinButtonGetRange                      ,


-- ** getSnapToTicks #method:getSnapToTicks#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetSnapToTicksMethodInfo      ,
#endif
    spinButtonGetSnapToTicks                ,


-- ** getUpdatePolicy #method:getUpdatePolicy#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetUpdatePolicyMethodInfo     ,
#endif
    spinButtonGetUpdatePolicy               ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetValueMethodInfo            ,
#endif
    spinButtonGetValue                      ,


-- ** getValueAsInt #method:getValueAsInt#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetValueAsIntMethodInfo       ,
#endif
    spinButtonGetValueAsInt                 ,


-- ** getWrap #method:getWrap#

#if defined(ENABLE_OVERLOADING)
    SpinButtonGetWrapMethodInfo             ,
#endif
    spinButtonGetWrap                       ,


-- ** new #method:new#

    spinButtonNew                           ,


-- ** newWithRange #method:newWithRange#

    spinButtonNewWithRange                  ,


-- ** setActivatesDefault #method:setActivatesDefault#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetActivatesDefaultMethodInfo ,
#endif
    spinButtonSetActivatesDefault           ,


-- ** setAdjustment #method:setAdjustment#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetAdjustmentMethodInfo       ,
#endif
    spinButtonSetAdjustment                 ,


-- ** setClimbRate #method:setClimbRate#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetClimbRateMethodInfo        ,
#endif
    spinButtonSetClimbRate                  ,


-- ** setDigits #method:setDigits#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetDigitsMethodInfo           ,
#endif
    spinButtonSetDigits                     ,


-- ** setIncrements #method:setIncrements#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetIncrementsMethodInfo       ,
#endif
    spinButtonSetIncrements                 ,


-- ** setNumeric #method:setNumeric#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetNumericMethodInfo          ,
#endif
    spinButtonSetNumeric                    ,


-- ** setRange #method:setRange#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetRangeMethodInfo            ,
#endif
    spinButtonSetRange                      ,


-- ** setSnapToTicks #method:setSnapToTicks#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetSnapToTicksMethodInfo      ,
#endif
    spinButtonSetSnapToTicks                ,


-- ** setUpdatePolicy #method:setUpdatePolicy#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetUpdatePolicyMethodInfo     ,
#endif
    spinButtonSetUpdatePolicy               ,


-- ** setValue #method:setValue#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetValueMethodInfo            ,
#endif
    spinButtonSetValue                      ,


-- ** setWrap #method:setWrap#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSetWrapMethodInfo             ,
#endif
    spinButtonSetWrap                       ,


-- ** spin #method:spin#

#if defined(ENABLE_OVERLOADING)
    SpinButtonSpinMethodInfo                ,
#endif
    spinButtonSpin                          ,


-- ** update #method:update#

#if defined(ENABLE_OVERLOADING)
    SpinButtonUpdateMethodInfo              ,
#endif
    spinButtonUpdate                        ,




 -- * Properties


-- ** activatesDefault #attr:activatesDefault#
-- | Whether to activate the default widget when the spin button is activated.
-- 
-- See [SpinButton::activate]("GI.Gtk.Objects.SpinButton#g:signal:activate") for what counts as activation.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    SpinButtonActivatesDefaultPropertyInfo  ,
#endif
    constructSpinButtonActivatesDefault     ,
    getSpinButtonActivatesDefault           ,
    setSpinButtonActivatesDefault           ,
#if defined(ENABLE_OVERLOADING)
    spinButtonActivatesDefault              ,
#endif


-- ** adjustment #attr:adjustment#
-- | The adjustment that holds the value of the spin button.

#if defined(ENABLE_OVERLOADING)
    SpinButtonAdjustmentPropertyInfo        ,
#endif
    constructSpinButtonAdjustment           ,
    getSpinButtonAdjustment                 ,
    setSpinButtonAdjustment                 ,
#if defined(ENABLE_OVERLOADING)
    spinButtonAdjustment                    ,
#endif


-- ** climbRate #attr:climbRate#
-- | The acceleration rate when you hold down a button or key.

#if defined(ENABLE_OVERLOADING)
    SpinButtonClimbRatePropertyInfo         ,
#endif
    constructSpinButtonClimbRate            ,
    getSpinButtonClimbRate                  ,
    setSpinButtonClimbRate                  ,
#if defined(ENABLE_OVERLOADING)
    spinButtonClimbRate                     ,
#endif


-- ** digits #attr:digits#
-- | The number of decimal places to display.

#if defined(ENABLE_OVERLOADING)
    SpinButtonDigitsPropertyInfo            ,
#endif
    constructSpinButtonDigits               ,
    getSpinButtonDigits                     ,
    setSpinButtonDigits                     ,
#if defined(ENABLE_OVERLOADING)
    spinButtonDigits                        ,
#endif


-- ** numeric #attr:numeric#
-- | Whether non-numeric characters should be ignored.

#if defined(ENABLE_OVERLOADING)
    SpinButtonNumericPropertyInfo           ,
#endif
    constructSpinButtonNumeric              ,
    getSpinButtonNumeric                    ,
    setSpinButtonNumeric                    ,
#if defined(ENABLE_OVERLOADING)
    spinButtonNumeric                       ,
#endif


-- ** snapToTicks #attr:snapToTicks#
-- | Whether erroneous values are automatically changed to the spin buttons
-- nearest step increment.

#if defined(ENABLE_OVERLOADING)
    SpinButtonSnapToTicksPropertyInfo       ,
#endif
    constructSpinButtonSnapToTicks          ,
    getSpinButtonSnapToTicks                ,
    setSpinButtonSnapToTicks                ,
#if defined(ENABLE_OVERLOADING)
    spinButtonSnapToTicks                   ,
#endif


-- ** updatePolicy #attr:updatePolicy#
-- | Whether the spin button should update always, or only when the value
-- is acceptable.

#if defined(ENABLE_OVERLOADING)
    SpinButtonUpdatePolicyPropertyInfo      ,
#endif
    constructSpinButtonUpdatePolicy         ,
    getSpinButtonUpdatePolicy               ,
    setSpinButtonUpdatePolicy               ,
#if defined(ENABLE_OVERLOADING)
    spinButtonUpdatePolicy                  ,
#endif


-- ** value #attr:value#
-- | The current value.

#if defined(ENABLE_OVERLOADING)
    SpinButtonValuePropertyInfo             ,
#endif
    constructSpinButtonValue                ,
    getSpinButtonValue                      ,
    setSpinButtonValue                      ,
#if defined(ENABLE_OVERLOADING)
    spinButtonValue                         ,
#endif


-- ** wrap #attr:wrap#
-- | Whether a spin button should wrap upon reaching its limits.

#if defined(ENABLE_OVERLOADING)
    SpinButtonWrapPropertyInfo              ,
#endif
    constructSpinButtonWrap                 ,
    getSpinButtonWrap                       ,
    setSpinButtonWrap                       ,
#if defined(ENABLE_OVERLOADING)
    spinButtonWrap                          ,
#endif




 -- * Signals


-- ** activate #signal:activate#

    SpinButtonActivateCallback              ,
#if defined(ENABLE_OVERLOADING)
    SpinButtonActivateSignalInfo            ,
#endif
    afterSpinButtonActivate                 ,
    onSpinButtonActivate                    ,


-- ** changeValue #signal:changeValue#

    SpinButtonChangeValueCallback           ,
#if defined(ENABLE_OVERLOADING)
    SpinButtonChangeValueSignalInfo         ,
#endif
    afterSpinButtonChangeValue              ,
    onSpinButtonChangeValue                 ,


-- ** input #signal:input#

    SpinButtonInputCallback                 ,
#if defined(ENABLE_OVERLOADING)
    SpinButtonInputSignalInfo               ,
#endif
    afterSpinButtonInput                    ,
    onSpinButtonInput                       ,


-- ** output #signal:output#

    SpinButtonOutputCallback                ,
#if defined(ENABLE_OVERLOADING)
    SpinButtonOutputSignalInfo              ,
#endif
    afterSpinButtonOutput                   ,
    onSpinButtonOutput                      ,


-- ** valueChanged #signal:valueChanged#

    SpinButtonValueChangedCallback          ,
#if defined(ENABLE_OVERLOADING)
    SpinButtonValueChangedSignalInfo        ,
#endif
    afterSpinButtonValueChanged             ,
    onSpinButtonValueChanged                ,


-- ** wrapped #signal:wrapped#

    SpinButtonWrappedCallback               ,
#if defined(ENABLE_OVERLOADING)
    SpinButtonWrappedSignalInfo             ,
#endif
    afterSpinButtonWrapped                  ,
    onSpinButtonWrapped                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype SpinButton = SpinButton (SP.ManagedPtr SpinButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype SpinButton where
    toManagedPtr (SpinButton p) = p

foreign import ccall "gtk_spin_button_get_type"
    c_gtk_spin_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject SpinButton where
    glibType = c_gtk_spin_button_get_type

instance B.Types.GObject SpinButton

-- | Type class for types which can be safely cast to t'SpinButton', for instance with `toSpinButton`.
class (SP.GObject o, O.IsDescendantOf SpinButton o) => IsSpinButton o
instance (SP.GObject o, O.IsDescendantOf SpinButton o) => IsSpinButton o

instance O.HasParentTypes SpinButton
type instance O.ParentTypes SpinButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.CellEditable.CellEditable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Editable.Editable, Gtk.Orientable.Orientable]

-- | Cast to t'SpinButton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSpinButton :: (MIO.MonadIO m, IsSpinButton o) => o -> m SpinButton
toSpinButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo SpinButton

-- | Convert t'SpinButton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SpinButton) where
    gvalueGType_ = c_gtk_spin_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SpinButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SpinButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SpinButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSpinButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSpinButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveSpinButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveSpinButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveSpinButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveSpinButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveSpinButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveSpinButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveSpinButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveSpinButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveSpinButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveSpinButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSpinButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSpinButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveSpinButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveSpinButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveSpinButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveSpinButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveSpinButtonMethod "configure" o = SpinButtonConfigureMethodInfo
    ResolveSpinButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveSpinButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveSpinButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveSpinButtonMethod "delegateGetAccessiblePlatformState" o = Gtk.Editable.EditableDelegateGetAccessiblePlatformStateMethodInfo
    ResolveSpinButtonMethod "deleteSelection" o = Gtk.Editable.EditableDeleteSelectionMethodInfo
    ResolveSpinButtonMethod "deleteText" o = Gtk.Editable.EditableDeleteTextMethodInfo
    ResolveSpinButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveSpinButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveSpinButtonMethod "editingDone" o = Gtk.CellEditable.CellEditableEditingDoneMethodInfo
    ResolveSpinButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveSpinButtonMethod "finishDelegate" o = Gtk.Editable.EditableFinishDelegateMethodInfo
    ResolveSpinButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSpinButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSpinButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSpinButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveSpinButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveSpinButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveSpinButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveSpinButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveSpinButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveSpinButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveSpinButtonMethod "initDelegate" o = Gtk.Editable.EditableInitDelegateMethodInfo
    ResolveSpinButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveSpinButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveSpinButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveSpinButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveSpinButtonMethod "insertText" o = Gtk.Editable.EditableInsertTextMethodInfo
    ResolveSpinButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveSpinButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveSpinButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSpinButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveSpinButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveSpinButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveSpinButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveSpinButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveSpinButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveSpinButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveSpinButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveSpinButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSpinButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSpinButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveSpinButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveSpinButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveSpinButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveSpinButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveSpinButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveSpinButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveSpinButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSpinButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSpinButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveSpinButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveSpinButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveSpinButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveSpinButtonMethod "removeWidget" o = Gtk.CellEditable.CellEditableRemoveWidgetMethodInfo
    ResolveSpinButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveSpinButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveSpinButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveSpinButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSpinButtonMethod "selectRegion" o = Gtk.Editable.EditableSelectRegionMethodInfo
    ResolveSpinButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveSpinButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveSpinButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveSpinButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveSpinButtonMethod "spin" o = SpinButtonSpinMethodInfo
    ResolveSpinButtonMethod "startEditing" o = Gtk.CellEditable.CellEditableStartEditingMethodInfo
    ResolveSpinButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSpinButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSpinButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSpinButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveSpinButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveSpinButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveSpinButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveSpinButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveSpinButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSpinButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveSpinButtonMethod "update" o = SpinButtonUpdateMethodInfo
    ResolveSpinButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveSpinButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveSpinButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveSpinButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveSpinButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveSpinButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSpinButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveSpinButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveSpinButtonMethod "getActivatesDefault" o = SpinButtonGetActivatesDefaultMethodInfo
    ResolveSpinButtonMethod "getAdjustment" o = SpinButtonGetAdjustmentMethodInfo
    ResolveSpinButtonMethod "getAlignment" o = Gtk.Editable.EditableGetAlignmentMethodInfo
    ResolveSpinButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveSpinButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveSpinButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveSpinButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveSpinButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveSpinButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveSpinButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveSpinButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveSpinButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveSpinButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveSpinButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveSpinButtonMethod "getChars" o = Gtk.Editable.EditableGetCharsMethodInfo
    ResolveSpinButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveSpinButtonMethod "getClimbRate" o = SpinButtonGetClimbRateMethodInfo
    ResolveSpinButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveSpinButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveSpinButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveSpinButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveSpinButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveSpinButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSpinButtonMethod "getDelegate" o = Gtk.Editable.EditableGetDelegateMethodInfo
    ResolveSpinButtonMethod "getDigits" o = SpinButtonGetDigitsMethodInfo
    ResolveSpinButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveSpinButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveSpinButtonMethod "getEditable" o = Gtk.Editable.EditableGetEditableMethodInfo
    ResolveSpinButtonMethod "getEnableUndo" o = Gtk.Editable.EditableGetEnableUndoMethodInfo
    ResolveSpinButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveSpinButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveSpinButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveSpinButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveSpinButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveSpinButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveSpinButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveSpinButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveSpinButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveSpinButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveSpinButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveSpinButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveSpinButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveSpinButtonMethod "getIncrements" o = SpinButtonGetIncrementsMethodInfo
    ResolveSpinButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveSpinButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveSpinButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveSpinButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveSpinButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveSpinButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveSpinButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveSpinButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveSpinButtonMethod "getMaxWidthChars" o = Gtk.Editable.EditableGetMaxWidthCharsMethodInfo
    ResolveSpinButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveSpinButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveSpinButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveSpinButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveSpinButtonMethod "getNumeric" o = SpinButtonGetNumericMethodInfo
    ResolveSpinButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveSpinButtonMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveSpinButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveSpinButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveSpinButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveSpinButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveSpinButtonMethod "getPosition" o = Gtk.Editable.EditableGetPositionMethodInfo
    ResolveSpinButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveSpinButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveSpinButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveSpinButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSpinButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSpinButtonMethod "getRange" o = SpinButtonGetRangeMethodInfo
    ResolveSpinButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveSpinButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveSpinButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveSpinButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveSpinButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveSpinButtonMethod "getSelectionBounds" o = Gtk.Editable.EditableGetSelectionBoundsMethodInfo
    ResolveSpinButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveSpinButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveSpinButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveSpinButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveSpinButtonMethod "getSnapToTicks" o = SpinButtonGetSnapToTicksMethodInfo
    ResolveSpinButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveSpinButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveSpinButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveSpinButtonMethod "getText" o = Gtk.Editable.EditableGetTextMethodInfo
    ResolveSpinButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveSpinButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveSpinButtonMethod "getUpdatePolicy" o = SpinButtonGetUpdatePolicyMethodInfo
    ResolveSpinButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveSpinButtonMethod "getValue" o = SpinButtonGetValueMethodInfo
    ResolveSpinButtonMethod "getValueAsInt" o = SpinButtonGetValueAsIntMethodInfo
    ResolveSpinButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveSpinButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveSpinButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveSpinButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveSpinButtonMethod "getWidthChars" o = Gtk.Editable.EditableGetWidthCharsMethodInfo
    ResolveSpinButtonMethod "getWrap" o = SpinButtonGetWrapMethodInfo
    ResolveSpinButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveSpinButtonMethod "setActivatesDefault" o = SpinButtonSetActivatesDefaultMethodInfo
    ResolveSpinButtonMethod "setAdjustment" o = SpinButtonSetAdjustmentMethodInfo
    ResolveSpinButtonMethod "setAlignment" o = Gtk.Editable.EditableSetAlignmentMethodInfo
    ResolveSpinButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveSpinButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveSpinButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveSpinButtonMethod "setClimbRate" o = SpinButtonSetClimbRateMethodInfo
    ResolveSpinButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveSpinButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveSpinButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveSpinButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSpinButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSpinButtonMethod "setDigits" o = SpinButtonSetDigitsMethodInfo
    ResolveSpinButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveSpinButtonMethod "setEditable" o = Gtk.Editable.EditableSetEditableMethodInfo
    ResolveSpinButtonMethod "setEnableUndo" o = Gtk.Editable.EditableSetEnableUndoMethodInfo
    ResolveSpinButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveSpinButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveSpinButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveSpinButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveSpinButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveSpinButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveSpinButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveSpinButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveSpinButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveSpinButtonMethod "setIncrements" o = SpinButtonSetIncrementsMethodInfo
    ResolveSpinButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveSpinButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveSpinButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveSpinButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveSpinButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveSpinButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveSpinButtonMethod "setMaxWidthChars" o = Gtk.Editable.EditableSetMaxWidthCharsMethodInfo
    ResolveSpinButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveSpinButtonMethod "setNumeric" o = SpinButtonSetNumericMethodInfo
    ResolveSpinButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveSpinButtonMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveSpinButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveSpinButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveSpinButtonMethod "setPosition" o = Gtk.Editable.EditableSetPositionMethodInfo
    ResolveSpinButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSpinButtonMethod "setRange" o = SpinButtonSetRangeMethodInfo
    ResolveSpinButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveSpinButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveSpinButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveSpinButtonMethod "setSnapToTicks" o = SpinButtonSetSnapToTicksMethodInfo
    ResolveSpinButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveSpinButtonMethod "setText" o = Gtk.Editable.EditableSetTextMethodInfo
    ResolveSpinButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveSpinButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveSpinButtonMethod "setUpdatePolicy" o = SpinButtonSetUpdatePolicyMethodInfo
    ResolveSpinButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveSpinButtonMethod "setValue" o = SpinButtonSetValueMethodInfo
    ResolveSpinButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveSpinButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveSpinButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveSpinButtonMethod "setWidthChars" o = Gtk.Editable.EditableSetWidthCharsMethodInfo
    ResolveSpinButtonMethod "setWrap" o = SpinButtonSetWrapMethodInfo
    ResolveSpinButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSpinButtonMethod t SpinButton, O.OverloadedMethod info SpinButton p) => OL.IsLabel t (SpinButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSpinButtonMethod t SpinButton, O.OverloadedMethod info SpinButton p, R.HasField t SpinButton p) => R.HasField t SpinButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSpinButtonMethod t SpinButton, O.OverloadedMethodInfo info SpinButton) => OL.IsLabel t (O.MethodProxy info SpinButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SpinButton::activate
-- | Emitted when the spin button is activated.
-- 
-- The keybindings for this signal are all forms of the \<kbd>Enter\<\/kbd> key.
-- 
-- If the \<kbd>Enter\<\/kbd> key results in the value being committed to the
-- spin button, then activation does not occur until \<kbd>Enter\<\/kbd> is
-- pressed again.
-- 
-- /Since: 4.14/
type SpinButtonActivateCallback =
    IO ()

type C_SpinButtonActivateCallback =
    Ptr SpinButton ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SpinButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_SpinButtonActivateCallback :: C_SpinButtonActivateCallback -> IO (FunPtr C_SpinButtonActivateCallback)

wrap_SpinButtonActivateCallback :: 
    GObject a => (a -> SpinButtonActivateCallback) ->
    C_SpinButtonActivateCallback
wrap_SpinButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' spinButton #activate callback
-- @
-- 
-- 
onSpinButtonActivate :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonActivateCallback) -> m SignalHandlerId
onSpinButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonActivateCallback wrapped
    wrapped'' <- mk_SpinButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' spinButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSpinButtonActivate :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonActivateCallback) -> m SignalHandlerId
afterSpinButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonActivateCallback wrapped
    wrapped'' <- mk_SpinButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SpinButtonActivateSignalInfo
instance SignalInfo SpinButtonActivateSignalInfo where
    type HaskellCallbackType SpinButtonActivateSignalInfo = SpinButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SpinButtonActivateCallback cb
        cb'' <- mk_SpinButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:signal:activate"})

#endif

-- signal SpinButton::change-value
-- | Emitted when the user initiates a value change.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control the cursor
-- programmatically.
-- 
-- The default bindings for this signal are Up\/Down and PageUp\/PageDown.
type SpinButtonChangeValueCallback =
    Gtk.Enums.ScrollType
    -- ^ /@scroll@/: a @GtkScrollType@ to specify the speed and amount of change
    -> IO ()

type C_SpinButtonChangeValueCallback =
    Ptr SpinButton ->                       -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SpinButtonChangeValueCallback`.
foreign import ccall "wrapper"
    mk_SpinButtonChangeValueCallback :: C_SpinButtonChangeValueCallback -> IO (FunPtr C_SpinButtonChangeValueCallback)

wrap_SpinButtonChangeValueCallback :: 
    GObject a => (a -> SpinButtonChangeValueCallback) ->
    C_SpinButtonChangeValueCallback
wrap_SpinButtonChangeValueCallback gi'cb gi'selfPtr scroll _ = do
    let scroll' = (toEnum . fromIntegral) scroll
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  scroll'


-- | Connect a signal handler for the [changeValue](#signal:changeValue) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' spinButton #changeValue callback
-- @
-- 
-- 
onSpinButtonChangeValue :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonChangeValueCallback) -> m SignalHandlerId
onSpinButtonChangeValue obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonChangeValueCallback wrapped
    wrapped'' <- mk_SpinButtonChangeValueCallback wrapped'
    connectSignalFunPtr obj "change-value" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changeValue](#signal:changeValue) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' spinButton #changeValue callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSpinButtonChangeValue :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonChangeValueCallback) -> m SignalHandlerId
afterSpinButtonChangeValue obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonChangeValueCallback wrapped
    wrapped'' <- mk_SpinButtonChangeValueCallback wrapped'
    connectSignalFunPtr obj "change-value" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SpinButtonChangeValueSignalInfo
instance SignalInfo SpinButtonChangeValueSignalInfo where
    type HaskellCallbackType SpinButtonChangeValueSignalInfo = SpinButtonChangeValueCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SpinButtonChangeValueCallback cb
        cb'' <- mk_SpinButtonChangeValueCallback cb'
        connectSignalFunPtr obj "change-value" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton::change-value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:signal:changeValue"})

#endif

-- signal SpinButton::input
-- | Emitted to convert the users input into a double value.
-- 
-- The signal handler is expected to use 'GI.Gtk.Interfaces.Editable.editableGetText'
-- to retrieve the text of the spinbutton and set /@newValue@/ to the
-- new value.
-- 
-- The default conversion uses 'GI.GLib.Functions.strtod'.
type SpinButtonInputCallback =
    IO ((Int32, Double))
    -- ^ __Returns:__ 'P.True' for a successful conversion, 'P.False' if the input
    --   was not handled, and 'GI.Gtk.Constants.INPUT_ERROR' if the conversion failed.

type C_SpinButtonInputCallback =
    Ptr SpinButton ->                       -- object
    Ptr CDouble ->
    Ptr () ->                               -- user_data
    IO Int32

-- | Generate a function pointer callable from C code, from a `C_SpinButtonInputCallback`.
foreign import ccall "wrapper"
    mk_SpinButtonInputCallback :: C_SpinButtonInputCallback -> IO (FunPtr C_SpinButtonInputCallback)

wrap_SpinButtonInputCallback :: 
    GObject a => (a -> SpinButtonInputCallback) ->
    C_SpinButtonInputCallback
wrap_SpinButtonInputCallback gi'cb gi'selfPtr newValue _ = do
    (result, outnewValue) <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let outnewValue' = realToFrac outnewValue
    poke newValue outnewValue'
    return result


-- | Connect a signal handler for the [input](#signal:input) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' spinButton #input callback
-- @
-- 
-- 
onSpinButtonInput :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonInputCallback) -> m SignalHandlerId
onSpinButtonInput obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonInputCallback wrapped
    wrapped'' <- mk_SpinButtonInputCallback wrapped'
    connectSignalFunPtr obj "input" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [input](#signal:input) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' spinButton #input callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSpinButtonInput :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonInputCallback) -> m SignalHandlerId
afterSpinButtonInput obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonInputCallback wrapped
    wrapped'' <- mk_SpinButtonInputCallback wrapped'
    connectSignalFunPtr obj "input" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SpinButtonInputSignalInfo
instance SignalInfo SpinButtonInputSignalInfo where
    type HaskellCallbackType SpinButtonInputSignalInfo = SpinButtonInputCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SpinButtonInputCallback cb
        cb'' <- mk_SpinButtonInputCallback cb'
        connectSignalFunPtr obj "input" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton::input"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:signal:input"})

#endif

-- signal SpinButton::output
-- | Emitted to tweak the formatting of the value for display.
-- 
-- 
-- === /c code/
-- >// show leading zeros
-- >static gboolean
-- >on_output (GtkSpinButton *spin,
-- >           gpointer       data)
-- >{
-- >   char *text;
-- >   int value;
-- >
-- >   value = gtk_spin_button_get_value_as_int (spin);
-- >   text = g_strdup_printf ("%02d", value);
-- >   gtk_editable_set_text (GTK_EDITABLE (spin), text):
-- >   g_free (text);
-- >
-- >   return TRUE;
-- >}
type SpinButtonOutputCallback =
    IO Bool
    -- ^ __Returns:__ 'P.True' if the value has been displayed

type C_SpinButtonOutputCallback =
    Ptr SpinButton ->                       -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_SpinButtonOutputCallback`.
foreign import ccall "wrapper"
    mk_SpinButtonOutputCallback :: C_SpinButtonOutputCallback -> IO (FunPtr C_SpinButtonOutputCallback)

wrap_SpinButtonOutputCallback :: 
    GObject a => (a -> SpinButtonOutputCallback) ->
    C_SpinButtonOutputCallback
wrap_SpinButtonOutputCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [output](#signal:output) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' spinButton #output callback
-- @
-- 
-- 
onSpinButtonOutput :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonOutputCallback) -> m SignalHandlerId
onSpinButtonOutput obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonOutputCallback wrapped
    wrapped'' <- mk_SpinButtonOutputCallback wrapped'
    connectSignalFunPtr obj "output" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [output](#signal:output) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' spinButton #output callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSpinButtonOutput :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonOutputCallback) -> m SignalHandlerId
afterSpinButtonOutput obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonOutputCallback wrapped
    wrapped'' <- mk_SpinButtonOutputCallback wrapped'
    connectSignalFunPtr obj "output" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SpinButtonOutputSignalInfo
instance SignalInfo SpinButtonOutputSignalInfo where
    type HaskellCallbackType SpinButtonOutputSignalInfo = SpinButtonOutputCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SpinButtonOutputCallback cb
        cb'' <- mk_SpinButtonOutputCallback cb'
        connectSignalFunPtr obj "output" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton::output"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:signal:output"})

#endif

-- signal SpinButton::value-changed
-- | Emitted when the value is changed.
-- 
-- Also see the [SpinButton::output]("GI.Gtk.Objects.SpinButton#g:signal:output") signal.
type SpinButtonValueChangedCallback =
    IO ()

type C_SpinButtonValueChangedCallback =
    Ptr SpinButton ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SpinButtonValueChangedCallback`.
foreign import ccall "wrapper"
    mk_SpinButtonValueChangedCallback :: C_SpinButtonValueChangedCallback -> IO (FunPtr C_SpinButtonValueChangedCallback)

wrap_SpinButtonValueChangedCallback :: 
    GObject a => (a -> SpinButtonValueChangedCallback) ->
    C_SpinButtonValueChangedCallback
wrap_SpinButtonValueChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [valueChanged](#signal:valueChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' spinButton #valueChanged callback
-- @
-- 
-- 
onSpinButtonValueChanged :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonValueChangedCallback) -> m SignalHandlerId
onSpinButtonValueChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonValueChangedCallback wrapped
    wrapped'' <- mk_SpinButtonValueChangedCallback wrapped'
    connectSignalFunPtr obj "value-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [valueChanged](#signal:valueChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' spinButton #valueChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSpinButtonValueChanged :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonValueChangedCallback) -> m SignalHandlerId
afterSpinButtonValueChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonValueChangedCallback wrapped
    wrapped'' <- mk_SpinButtonValueChangedCallback wrapped'
    connectSignalFunPtr obj "value-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SpinButtonValueChangedSignalInfo
instance SignalInfo SpinButtonValueChangedSignalInfo where
    type HaskellCallbackType SpinButtonValueChangedSignalInfo = SpinButtonValueChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SpinButtonValueChangedCallback cb
        cb'' <- mk_SpinButtonValueChangedCallback cb'
        connectSignalFunPtr obj "value-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton::value-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:signal:valueChanged"})

#endif

-- signal SpinButton::wrapped
-- | Emitted right after the spinbutton wraps from its maximum
-- to its minimum value or vice-versa.
type SpinButtonWrappedCallback =
    IO ()

type C_SpinButtonWrappedCallback =
    Ptr SpinButton ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SpinButtonWrappedCallback`.
foreign import ccall "wrapper"
    mk_SpinButtonWrappedCallback :: C_SpinButtonWrappedCallback -> IO (FunPtr C_SpinButtonWrappedCallback)

wrap_SpinButtonWrappedCallback :: 
    GObject a => (a -> SpinButtonWrappedCallback) ->
    C_SpinButtonWrappedCallback
wrap_SpinButtonWrappedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [wrapped](#signal:wrapped) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' spinButton #wrapped callback
-- @
-- 
-- 
onSpinButtonWrapped :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonWrappedCallback) -> m SignalHandlerId
onSpinButtonWrapped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonWrappedCallback wrapped
    wrapped'' <- mk_SpinButtonWrappedCallback wrapped'
    connectSignalFunPtr obj "wrapped" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [wrapped](#signal:wrapped) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' spinButton #wrapped callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSpinButtonWrapped :: (IsSpinButton a, MonadIO m) => a -> ((?self :: a) => SpinButtonWrappedCallback) -> m SignalHandlerId
afterSpinButtonWrapped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SpinButtonWrappedCallback wrapped
    wrapped'' <- mk_SpinButtonWrappedCallback wrapped'
    connectSignalFunPtr obj "wrapped" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SpinButtonWrappedSignalInfo
instance SignalInfo SpinButtonWrappedSignalInfo where
    type HaskellCallbackType SpinButtonWrappedSignalInfo = SpinButtonWrappedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SpinButtonWrappedCallback cb
        cb'' <- mk_SpinButtonWrappedCallback cb'
        connectSignalFunPtr obj "wrapped" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton::wrapped"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:signal:wrapped"})

#endif

-- VVV Prop "activates-default"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@activates-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #activatesDefault
-- @
getSpinButtonActivatesDefault :: (MonadIO m, IsSpinButton o) => o -> m Bool
getSpinButtonActivatesDefault obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "activates-default"

-- | Set the value of the “@activates-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #activatesDefault 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonActivatesDefault :: (MonadIO m, IsSpinButton o) => o -> Bool -> m ()
setSpinButtonActivatesDefault obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "activates-default" val

-- | Construct a t'GValueConstruct' with valid value for the “@activates-default@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonActivatesDefault :: (IsSpinButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSpinButtonActivatesDefault val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "activates-default" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonActivatesDefaultPropertyInfo
instance AttrInfo SpinButtonActivatesDefaultPropertyInfo where
    type AttrAllowedOps SpinButtonActivatesDefaultPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonActivatesDefaultPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonActivatesDefaultPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SpinButtonActivatesDefaultPropertyInfo = (~) Bool
    type AttrTransferType SpinButtonActivatesDefaultPropertyInfo = Bool
    type AttrGetType SpinButtonActivatesDefaultPropertyInfo = Bool
    type AttrLabel SpinButtonActivatesDefaultPropertyInfo = "activates-default"
    type AttrOrigin SpinButtonActivatesDefaultPropertyInfo = SpinButton
    attrGet = getSpinButtonActivatesDefault
    attrSet = setSpinButtonActivatesDefault
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonActivatesDefault
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.activatesDefault"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:activatesDefault"
        })
#endif

-- VVV Prop "adjustment"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Adjustment"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@adjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #adjustment
-- @
getSpinButtonAdjustment :: (MonadIO m, IsSpinButton o) => o -> m Gtk.Adjustment.Adjustment
getSpinButtonAdjustment obj = MIO.liftIO $ checkUnexpectedNothing "getSpinButtonAdjustment" $ B.Properties.getObjectPropertyObject obj "adjustment" Gtk.Adjustment.Adjustment

-- | Set the value of the “@adjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #adjustment 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonAdjustment :: (MonadIO m, IsSpinButton o, Gtk.Adjustment.IsAdjustment a) => o -> a -> m ()
setSpinButtonAdjustment obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "adjustment" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@adjustment@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonAdjustment :: (IsSpinButton o, MIO.MonadIO m, Gtk.Adjustment.IsAdjustment a) => a -> m (GValueConstruct o)
constructSpinButtonAdjustment val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "adjustment" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SpinButtonAdjustmentPropertyInfo
instance AttrInfo SpinButtonAdjustmentPropertyInfo where
    type AttrAllowedOps SpinButtonAdjustmentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonAdjustmentPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonAdjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferTypeConstraint SpinButtonAdjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferType SpinButtonAdjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrGetType SpinButtonAdjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrLabel SpinButtonAdjustmentPropertyInfo = "adjustment"
    type AttrOrigin SpinButtonAdjustmentPropertyInfo = SpinButton
    attrGet = getSpinButtonAdjustment
    attrSet = setSpinButtonAdjustment
    attrTransfer _ v = do
        unsafeCastTo Gtk.Adjustment.Adjustment v
    attrConstruct = constructSpinButtonAdjustment
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.adjustment"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:adjustment"
        })
#endif

-- VVV Prop "climb-rate"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@climb-rate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #climbRate
-- @
getSpinButtonClimbRate :: (MonadIO m, IsSpinButton o) => o -> m Double
getSpinButtonClimbRate obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "climb-rate"

-- | Set the value of the “@climb-rate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #climbRate 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonClimbRate :: (MonadIO m, IsSpinButton o) => o -> Double -> m ()
setSpinButtonClimbRate obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "climb-rate" val

-- | Construct a t'GValueConstruct' with valid value for the “@climb-rate@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonClimbRate :: (IsSpinButton o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructSpinButtonClimbRate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "climb-rate" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonClimbRatePropertyInfo
instance AttrInfo SpinButtonClimbRatePropertyInfo where
    type AttrAllowedOps SpinButtonClimbRatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonClimbRatePropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonClimbRatePropertyInfo = (~) Double
    type AttrTransferTypeConstraint SpinButtonClimbRatePropertyInfo = (~) Double
    type AttrTransferType SpinButtonClimbRatePropertyInfo = Double
    type AttrGetType SpinButtonClimbRatePropertyInfo = Double
    type AttrLabel SpinButtonClimbRatePropertyInfo = "climb-rate"
    type AttrOrigin SpinButtonClimbRatePropertyInfo = SpinButton
    attrGet = getSpinButtonClimbRate
    attrSet = setSpinButtonClimbRate
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonClimbRate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.climbRate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:climbRate"
        })
#endif

-- VVV Prop "digits"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@digits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #digits
-- @
getSpinButtonDigits :: (MonadIO m, IsSpinButton o) => o -> m Word32
getSpinButtonDigits obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "digits"

-- | Set the value of the “@digits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #digits 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonDigits :: (MonadIO m, IsSpinButton o) => o -> Word32 -> m ()
setSpinButtonDigits obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "digits" val

-- | Construct a t'GValueConstruct' with valid value for the “@digits@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonDigits :: (IsSpinButton o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructSpinButtonDigits val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "digits" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonDigitsPropertyInfo
instance AttrInfo SpinButtonDigitsPropertyInfo where
    type AttrAllowedOps SpinButtonDigitsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonDigitsPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonDigitsPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint SpinButtonDigitsPropertyInfo = (~) Word32
    type AttrTransferType SpinButtonDigitsPropertyInfo = Word32
    type AttrGetType SpinButtonDigitsPropertyInfo = Word32
    type AttrLabel SpinButtonDigitsPropertyInfo = "digits"
    type AttrOrigin SpinButtonDigitsPropertyInfo = SpinButton
    attrGet = getSpinButtonDigits
    attrSet = setSpinButtonDigits
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonDigits
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.digits"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:digits"
        })
#endif

-- VVV Prop "numeric"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@numeric@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #numeric
-- @
getSpinButtonNumeric :: (MonadIO m, IsSpinButton o) => o -> m Bool
getSpinButtonNumeric obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "numeric"

-- | Set the value of the “@numeric@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #numeric 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonNumeric :: (MonadIO m, IsSpinButton o) => o -> Bool -> m ()
setSpinButtonNumeric obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "numeric" val

-- | Construct a t'GValueConstruct' with valid value for the “@numeric@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonNumeric :: (IsSpinButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSpinButtonNumeric val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "numeric" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonNumericPropertyInfo
instance AttrInfo SpinButtonNumericPropertyInfo where
    type AttrAllowedOps SpinButtonNumericPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonNumericPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonNumericPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SpinButtonNumericPropertyInfo = (~) Bool
    type AttrTransferType SpinButtonNumericPropertyInfo = Bool
    type AttrGetType SpinButtonNumericPropertyInfo = Bool
    type AttrLabel SpinButtonNumericPropertyInfo = "numeric"
    type AttrOrigin SpinButtonNumericPropertyInfo = SpinButton
    attrGet = getSpinButtonNumeric
    attrSet = setSpinButtonNumeric
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonNumeric
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.numeric"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:numeric"
        })
#endif

-- VVV Prop "snap-to-ticks"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@snap-to-ticks@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #snapToTicks
-- @
getSpinButtonSnapToTicks :: (MonadIO m, IsSpinButton o) => o -> m Bool
getSpinButtonSnapToTicks obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "snap-to-ticks"

-- | Set the value of the “@snap-to-ticks@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #snapToTicks 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonSnapToTicks :: (MonadIO m, IsSpinButton o) => o -> Bool -> m ()
setSpinButtonSnapToTicks obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "snap-to-ticks" val

-- | Construct a t'GValueConstruct' with valid value for the “@snap-to-ticks@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonSnapToTicks :: (IsSpinButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSpinButtonSnapToTicks val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "snap-to-ticks" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonSnapToTicksPropertyInfo
instance AttrInfo SpinButtonSnapToTicksPropertyInfo where
    type AttrAllowedOps SpinButtonSnapToTicksPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonSnapToTicksPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonSnapToTicksPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SpinButtonSnapToTicksPropertyInfo = (~) Bool
    type AttrTransferType SpinButtonSnapToTicksPropertyInfo = Bool
    type AttrGetType SpinButtonSnapToTicksPropertyInfo = Bool
    type AttrLabel SpinButtonSnapToTicksPropertyInfo = "snap-to-ticks"
    type AttrOrigin SpinButtonSnapToTicksPropertyInfo = SpinButton
    attrGet = getSpinButtonSnapToTicks
    attrSet = setSpinButtonSnapToTicks
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonSnapToTicks
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.snapToTicks"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:snapToTicks"
        })
#endif

-- VVV Prop "update-policy"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SpinButtonUpdatePolicy"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@update-policy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #updatePolicy
-- @
getSpinButtonUpdatePolicy :: (MonadIO m, IsSpinButton o) => o -> m Gtk.Enums.SpinButtonUpdatePolicy
getSpinButtonUpdatePolicy obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "update-policy"

-- | Set the value of the “@update-policy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #updatePolicy 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonUpdatePolicy :: (MonadIO m, IsSpinButton o) => o -> Gtk.Enums.SpinButtonUpdatePolicy -> m ()
setSpinButtonUpdatePolicy obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "update-policy" val

-- | Construct a t'GValueConstruct' with valid value for the “@update-policy@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonUpdatePolicy :: (IsSpinButton o, MIO.MonadIO m) => Gtk.Enums.SpinButtonUpdatePolicy -> m (GValueConstruct o)
constructSpinButtonUpdatePolicy val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "update-policy" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonUpdatePolicyPropertyInfo
instance AttrInfo SpinButtonUpdatePolicyPropertyInfo where
    type AttrAllowedOps SpinButtonUpdatePolicyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonUpdatePolicyPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonUpdatePolicyPropertyInfo = (~) Gtk.Enums.SpinButtonUpdatePolicy
    type AttrTransferTypeConstraint SpinButtonUpdatePolicyPropertyInfo = (~) Gtk.Enums.SpinButtonUpdatePolicy
    type AttrTransferType SpinButtonUpdatePolicyPropertyInfo = Gtk.Enums.SpinButtonUpdatePolicy
    type AttrGetType SpinButtonUpdatePolicyPropertyInfo = Gtk.Enums.SpinButtonUpdatePolicy
    type AttrLabel SpinButtonUpdatePolicyPropertyInfo = "update-policy"
    type AttrOrigin SpinButtonUpdatePolicyPropertyInfo = SpinButton
    attrGet = getSpinButtonUpdatePolicy
    attrSet = setSpinButtonUpdatePolicy
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonUpdatePolicy
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.updatePolicy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:updatePolicy"
        })
#endif

-- VVV Prop "value"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #value
-- @
getSpinButtonValue :: (MonadIO m, IsSpinButton o) => o -> m Double
getSpinButtonValue obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "value"

-- | Set the value of the “@value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonValue :: (MonadIO m, IsSpinButton o) => o -> Double -> m ()
setSpinButtonValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "value" val

-- | Construct a t'GValueConstruct' with valid value for the “@value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonValue :: (IsSpinButton o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructSpinButtonValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "value" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonValuePropertyInfo
instance AttrInfo SpinButtonValuePropertyInfo where
    type AttrAllowedOps SpinButtonValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonValuePropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonValuePropertyInfo = (~) Double
    type AttrTransferTypeConstraint SpinButtonValuePropertyInfo = (~) Double
    type AttrTransferType SpinButtonValuePropertyInfo = Double
    type AttrGetType SpinButtonValuePropertyInfo = Double
    type AttrLabel SpinButtonValuePropertyInfo = "value"
    type AttrOrigin SpinButtonValuePropertyInfo = SpinButton
    attrGet = getSpinButtonValue
    attrSet = setSpinButtonValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:value"
        })
#endif

-- VVV Prop "wrap"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@wrap@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' spinButton #wrap
-- @
getSpinButtonWrap :: (MonadIO m, IsSpinButton o) => o -> m Bool
getSpinButtonWrap obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "wrap"

-- | Set the value of the “@wrap@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' spinButton [ #wrap 'Data.GI.Base.Attributes.:=' value ]
-- @
setSpinButtonWrap :: (MonadIO m, IsSpinButton o) => o -> Bool -> m ()
setSpinButtonWrap obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "wrap" val

-- | Construct a t'GValueConstruct' with valid value for the “@wrap@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSpinButtonWrap :: (IsSpinButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSpinButtonWrap val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "wrap" val

#if defined(ENABLE_OVERLOADING)
data SpinButtonWrapPropertyInfo
instance AttrInfo SpinButtonWrapPropertyInfo where
    type AttrAllowedOps SpinButtonWrapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SpinButtonWrapPropertyInfo = IsSpinButton
    type AttrSetTypeConstraint SpinButtonWrapPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SpinButtonWrapPropertyInfo = (~) Bool
    type AttrTransferType SpinButtonWrapPropertyInfo = Bool
    type AttrGetType SpinButtonWrapPropertyInfo = Bool
    type AttrLabel SpinButtonWrapPropertyInfo = "wrap"
    type AttrOrigin SpinButtonWrapPropertyInfo = SpinButton
    attrGet = getSpinButtonWrap
    attrSet = setSpinButtonWrap
    attrTransfer _ v = do
        return v
    attrConstruct = constructSpinButtonWrap
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.wrap"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#g:attr:wrap"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SpinButton
type instance O.AttributeList SpinButton = SpinButtonAttributeList
type SpinButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("activatesDefault", SpinButtonActivatesDefaultPropertyInfo), '("adjustment", SpinButtonAdjustmentPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("climbRate", SpinButtonClimbRatePropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("cursorPosition", Gtk.Editable.EditableCursorPositionPropertyInfo), '("digits", SpinButtonDigitsPropertyInfo), '("editable", Gtk.Editable.EditableEditablePropertyInfo), '("editingCanceled", Gtk.CellEditable.CellEditableEditingCanceledPropertyInfo), '("enableUndo", Gtk.Editable.EditableEnableUndoPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxWidthChars", Gtk.Editable.EditableMaxWidthCharsPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("numeric", SpinButtonNumericPropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("selectionBound", Gtk.Editable.EditableSelectionBoundPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("snapToTicks", SpinButtonSnapToTicksPropertyInfo), '("text", Gtk.Editable.EditableTextPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("updatePolicy", SpinButtonUpdatePolicyPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("value", SpinButtonValuePropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthChars", Gtk.Editable.EditableWidthCharsPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("wrap", SpinButtonWrapPropertyInfo), '("xalign", Gtk.Editable.EditableXalignPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
spinButtonActivatesDefault :: AttrLabelProxy "activatesDefault"
spinButtonActivatesDefault = AttrLabelProxy

spinButtonAdjustment :: AttrLabelProxy "adjustment"
spinButtonAdjustment = AttrLabelProxy

spinButtonClimbRate :: AttrLabelProxy "climbRate"
spinButtonClimbRate = AttrLabelProxy

spinButtonDigits :: AttrLabelProxy "digits"
spinButtonDigits = AttrLabelProxy

spinButtonNumeric :: AttrLabelProxy "numeric"
spinButtonNumeric = AttrLabelProxy

spinButtonSnapToTicks :: AttrLabelProxy "snapToTicks"
spinButtonSnapToTicks = AttrLabelProxy

spinButtonUpdatePolicy :: AttrLabelProxy "updatePolicy"
spinButtonUpdatePolicy = AttrLabelProxy

spinButtonValue :: AttrLabelProxy "value"
spinButtonValue = AttrLabelProxy

spinButtonWrap :: AttrLabelProxy "wrap"
spinButtonWrap = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SpinButton = SpinButtonSignalList
type SpinButtonSignalList = ('[ '("activate", SpinButtonActivateSignalInfo), '("changeValue", SpinButtonChangeValueSignalInfo), '("changed", Gtk.Editable.EditableChangedSignalInfo), '("deleteText", Gtk.Editable.EditableDeleteTextSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("editingDone", Gtk.CellEditable.CellEditableEditingDoneSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("input", SpinButtonInputSignalInfo), '("insertText", Gtk.Editable.EditableInsertTextSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("output", SpinButtonOutputSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("removeWidget", Gtk.CellEditable.CellEditableRemoveWidgetSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("valueChanged", SpinButtonValueChangedSignalInfo), '("wrapped", SpinButtonWrappedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SpinButton::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkAdjustment` that this spin button should use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "climb_rate"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "specifies by how much the rate of change in the value will\n  accelerate if you continue to hold down an up/down button or arrow key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "digits"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of decimal places to display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SpinButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_new" gtk_spin_button_new :: 
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    CDouble ->                              -- climb_rate : TBasicType TDouble
    Word32 ->                               -- digits : TBasicType TUInt
    IO (Ptr SpinButton)

-- | Creates a new @GtkSpinButton@.
spinButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Adjustment.IsAdjustment a) =>
    Maybe (a)
    -- ^ /@adjustment@/: the @GtkAdjustment@ that this spin button should use
    -> Double
    -- ^ /@climbRate@/: specifies by how much the rate of change in the value will
    --   accelerate if you continue to hold down an up\/down button or arrow key
    -> Word32
    -- ^ /@digits@/: the number of decimal places to display
    -> m SpinButton
    -- ^ __Returns:__ The new @GtkSpinButton@
spinButtonNew adjustment climbRate digits = liftIO $ do
    maybeAdjustment <- case adjustment of
        Nothing -> return FP.nullPtr
        Just jAdjustment -> do
            jAdjustment' <- unsafeManagedPtrCastPtr jAdjustment
            return jAdjustment'
    let climbRate' = realToFrac climbRate
    result <- gtk_spin_button_new maybeAdjustment climbRate' digits
    checkUnexpectedReturnNULL "spinButtonNew" result
    result' <- (newObject SpinButton) result
    whenJust adjustment touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SpinButton::new_with_range
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "min"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Minimum allowable value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Maximum allowable value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "step"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Increment added or subtracted by spinning the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SpinButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_new_with_range" gtk_spin_button_new_with_range :: 
    CDouble ->                              -- min : TBasicType TDouble
    CDouble ->                              -- max : TBasicType TDouble
    CDouble ->                              -- step : TBasicType TDouble
    IO (Ptr SpinButton)

-- | Creates a new @GtkSpinButton@ with the given properties.
-- 
-- This is a convenience constructor that allows creation
-- of a numeric @GtkSpinButton@ without manually creating
-- an adjustment. The value is initially set to the minimum
-- value and a page increment of 10 * /@step@/ is the default.
-- The precision of the spin button is equivalent to the
-- precision of /@step@/.
-- 
-- Note that the way in which the precision is derived works
-- best if /@step@/ is a power of ten. If the resulting precision
-- is not suitable for your needs, use
-- 'GI.Gtk.Objects.SpinButton.spinButtonSetDigits' to correct it.
spinButtonNewWithRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Double
    -- ^ /@min@/: Minimum allowable value
    -> Double
    -- ^ /@max@/: Maximum allowable value
    -> Double
    -- ^ /@step@/: Increment added or subtracted by spinning the widget
    -> m SpinButton
    -- ^ __Returns:__ The new @GtkSpinButton@
spinButtonNewWithRange min max step = liftIO $ do
    let min' = realToFrac min
    let max' = realToFrac max
    let step' = realToFrac step
    result <- gtk_spin_button_new_with_range min' max' step'
    checkUnexpectedReturnNULL "spinButtonNewWithRange" result
    result' <- (newObject SpinButton) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SpinButton::configure
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GtkAdjustment` to replace the spin button\8217s\n  existing adjustment, or %NULL to leave its current adjustment unchanged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "climb_rate"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new climb rate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "digits"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of decimal places to display in the spin button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_configure" gtk_spin_button_configure :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    CDouble ->                              -- climb_rate : TBasicType TDouble
    Word32 ->                               -- digits : TBasicType TUInt
    IO ()

-- | Changes the properties of an existing spin button.
-- 
-- The adjustment, climb rate, and number of decimal places
-- are updated accordingly.
spinButtonConfigure ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Maybe (b)
    -- ^ /@adjustment@/: a @GtkAdjustment@ to replace the spin button’s
    --   existing adjustment, or 'P.Nothing' to leave its current adjustment unchanged
    -> Double
    -- ^ /@climbRate@/: the new climb rate
    -> Word32
    -- ^ /@digits@/: the number of decimal places to display in the spin button
    -> m ()
spinButtonConfigure spinButton adjustment climbRate digits = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    maybeAdjustment <- case adjustment of
        Nothing -> return FP.nullPtr
        Just jAdjustment -> do
            jAdjustment' <- unsafeManagedPtrCastPtr jAdjustment
            return jAdjustment'
    let climbRate' = realToFrac climbRate
    gtk_spin_button_configure spinButton' maybeAdjustment climbRate' digits
    touchManagedPtr spinButton
    whenJust adjustment touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonConfigureMethodInfo
instance (signature ~ (Maybe (b) -> Double -> Word32 -> m ()), MonadIO m, IsSpinButton a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod SpinButtonConfigureMethodInfo a signature where
    overloadedMethod = spinButtonConfigure

instance O.OverloadedMethodInfo SpinButtonConfigureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonConfigure",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonConfigure"
        })


#endif

-- method SpinButton::get_activates_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_activates_default" gtk_spin_button_get_activates_default :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CInt

-- | Retrieves the value set by 'GI.Gtk.Objects.SpinButton.spinButtonSetActivatesDefault'.
-- 
-- /Since: 4.14/
spinButtonGetActivatesDefault ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the spin button will activate the default widget
spinButtonGetActivatesDefault spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_activates_default spinButton'
    let result' = (/= 0) result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetActivatesDefaultMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetActivatesDefaultMethodInfo a signature where
    overloadedMethod = spinButtonGetActivatesDefault

instance O.OverloadedMethodInfo SpinButtonGetActivatesDefaultMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetActivatesDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetActivatesDefault"
        })


#endif

-- method SpinButton::get_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Adjustment" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_adjustment" gtk_spin_button_get_adjustment :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO (Ptr Gtk.Adjustment.Adjustment)

-- | Get the adjustment associated with a @GtkSpinButton@.
spinButtonGetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Gtk.Adjustment.Adjustment
    -- ^ __Returns:__ the @GtkAdjustment@ of /@spinButton@/
spinButtonGetAdjustment spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_adjustment spinButton'
    checkUnexpectedReturnNULL "spinButtonGetAdjustment" result
    result' <- (newObject Gtk.Adjustment.Adjustment) result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetAdjustmentMethodInfo
instance (signature ~ (m Gtk.Adjustment.Adjustment), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetAdjustmentMethodInfo a signature where
    overloadedMethod = spinButtonGetAdjustment

instance O.OverloadedMethodInfo SpinButtonGetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetAdjustment"
        })


#endif

-- method SpinButton::get_climb_rate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_climb_rate" gtk_spin_button_get_climb_rate :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CDouble

-- | Returns the acceleration rate for repeated changes.
spinButtonGetClimbRate ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Double
    -- ^ __Returns:__ the acceleration rate
spinButtonGetClimbRate spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_climb_rate spinButton'
    let result' = realToFrac result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetClimbRateMethodInfo
instance (signature ~ (m Double), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetClimbRateMethodInfo a signature where
    overloadedMethod = spinButtonGetClimbRate

instance O.OverloadedMethodInfo SpinButtonGetClimbRateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetClimbRate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetClimbRate"
        })


#endif

-- method SpinButton::get_digits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_digits" gtk_spin_button_get_digits :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO Word32

-- | Fetches the precision of /@spinButton@/.
spinButtonGetDigits ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Word32
    -- ^ __Returns:__ the current precision
spinButtonGetDigits spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_digits spinButton'
    touchManagedPtr spinButton
    return result

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetDigitsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetDigitsMethodInfo a signature where
    overloadedMethod = spinButtonGetDigits

instance O.OverloadedMethodInfo SpinButtonGetDigitsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetDigits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetDigits"
        })


#endif

-- method SpinButton::get_increments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "step"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store step increment"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store page increment"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_increments" gtk_spin_button_get_increments :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    Ptr CDouble ->                          -- step : TBasicType TDouble
    Ptr CDouble ->                          -- page : TBasicType TDouble
    IO ()

-- | Gets the current step and page the increments
-- used by /@spinButton@/.
-- 
-- See 'GI.Gtk.Objects.SpinButton.spinButtonSetIncrements'.
spinButtonGetIncrements ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m ((Double, Double))
spinButtonGetIncrements spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    step <- allocMem :: IO (Ptr CDouble)
    page <- allocMem :: IO (Ptr CDouble)
    gtk_spin_button_get_increments spinButton' step page
    step' <- peek step
    let step'' = realToFrac step'
    page' <- peek page
    let page'' = realToFrac page'
    touchManagedPtr spinButton
    freeMem step
    freeMem page
    return (step'', page'')

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetIncrementsMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetIncrementsMethodInfo a signature where
    overloadedMethod = spinButtonGetIncrements

instance O.OverloadedMethodInfo SpinButtonGetIncrementsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetIncrements",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetIncrements"
        })


#endif

-- method SpinButton::get_numeric
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_numeric" gtk_spin_button_get_numeric :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CInt

-- | Returns whether non-numeric text can be typed into the spin button.
spinButtonGetNumeric ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if only numeric text can be entered
spinButtonGetNumeric spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_numeric spinButton'
    let result' = (/= 0) result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetNumericMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetNumericMethodInfo a signature where
    overloadedMethod = spinButtonGetNumeric

instance O.OverloadedMethodInfo SpinButtonGetNumericMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetNumeric",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetNumeric"
        })


#endif

-- method SpinButton::get_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store minimum allowed value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store maximum allowed value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_range" gtk_spin_button_get_range :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    Ptr CDouble ->                          -- min : TBasicType TDouble
    Ptr CDouble ->                          -- max : TBasicType TDouble
    IO ()

-- | Gets the range allowed for /@spinButton@/.
-- 
-- See 'GI.Gtk.Objects.SpinButton.spinButtonSetRange'.
spinButtonGetRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m ((Double, Double))
spinButtonGetRange spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    min <- allocMem :: IO (Ptr CDouble)
    max <- allocMem :: IO (Ptr CDouble)
    gtk_spin_button_get_range spinButton' min max
    min' <- peek min
    let min'' = realToFrac min'
    max' <- peek max
    let max'' = realToFrac max'
    touchManagedPtr spinButton
    freeMem min
    freeMem max
    return (min'', max'')

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetRangeMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetRangeMethodInfo a signature where
    overloadedMethod = spinButtonGetRange

instance O.OverloadedMethodInfo SpinButtonGetRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetRange"
        })


#endif

-- method SpinButton::get_snap_to_ticks
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_snap_to_ticks" gtk_spin_button_get_snap_to_ticks :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CInt

-- | Returns whether the values are corrected to the nearest step.
spinButtonGetSnapToTicks ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if values are snapped to the nearest step
spinButtonGetSnapToTicks spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_snap_to_ticks spinButton'
    let result' = (/= 0) result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetSnapToTicksMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetSnapToTicksMethodInfo a signature where
    overloadedMethod = spinButtonGetSnapToTicks

instance O.OverloadedMethodInfo SpinButtonGetSnapToTicksMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetSnapToTicks",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetSnapToTicks"
        })


#endif

-- method SpinButton::get_update_policy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "SpinButtonUpdatePolicy" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_update_policy" gtk_spin_button_get_update_policy :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CUInt

-- | Gets the update behavior of a spin button.
-- 
-- See 'GI.Gtk.Objects.SpinButton.spinButtonSetUpdatePolicy'.
spinButtonGetUpdatePolicy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Gtk.Enums.SpinButtonUpdatePolicy
    -- ^ __Returns:__ the current update policy
spinButtonGetUpdatePolicy spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_update_policy spinButton'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetUpdatePolicyMethodInfo
instance (signature ~ (m Gtk.Enums.SpinButtonUpdatePolicy), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetUpdatePolicyMethodInfo a signature where
    overloadedMethod = spinButtonGetUpdatePolicy

instance O.OverloadedMethodInfo SpinButtonGetUpdatePolicyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetUpdatePolicy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetUpdatePolicy"
        })


#endif

-- method SpinButton::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_value" gtk_spin_button_get_value :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CDouble

-- | Get the value in the /@spinButton@/.
spinButtonGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Double
    -- ^ __Returns:__ the value of /@spinButton@/
spinButtonGetValue spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_value spinButton'
    let result' = realToFrac result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetValueMethodInfo
instance (signature ~ (m Double), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetValueMethodInfo a signature where
    overloadedMethod = spinButtonGetValue

instance O.OverloadedMethodInfo SpinButtonGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetValue"
        })


#endif

-- method SpinButton::get_value_as_int
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_value_as_int" gtk_spin_button_get_value_as_int :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO Int32

-- | Get the value /@spinButton@/ represented as an integer.
spinButtonGetValueAsInt ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Int32
    -- ^ __Returns:__ the value of /@spinButton@/
spinButtonGetValueAsInt spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_value_as_int spinButton'
    touchManagedPtr spinButton
    return result

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetValueAsIntMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetValueAsIntMethodInfo a signature where
    overloadedMethod = spinButtonGetValueAsInt

instance O.OverloadedMethodInfo SpinButtonGetValueAsIntMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetValueAsInt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetValueAsInt"
        })


#endif

-- method SpinButton::get_wrap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_get_wrap" gtk_spin_button_get_wrap :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO CInt

-- | Returns whether the spin button’s value wraps around to the
-- opposite limit when the upper or lower limit of the range is
-- exceeded.
spinButtonGetWrap ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the spin button wraps around
spinButtonGetWrap spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    result <- gtk_spin_button_get_wrap spinButton'
    let result' = (/= 0) result
    touchManagedPtr spinButton
    return result'

#if defined(ENABLE_OVERLOADING)
data SpinButtonGetWrapMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonGetWrapMethodInfo a signature where
    overloadedMethod = spinButtonGetWrap

instance O.OverloadedMethodInfo SpinButtonGetWrapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonGetWrap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonGetWrap"
        })


#endif

-- method SpinButton::set_activates_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "activates_default"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE to activate window\8217s default widget on activation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_activates_default" gtk_spin_button_set_activates_default :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CInt ->                                 -- activates_default : TBasicType TBoolean
    IO ()

-- | Sets whether activating the spin button will activate the default
-- widget for the window containing the spin button.
-- 
-- See [SpinButton::activate]("GI.Gtk.Objects.SpinButton#g:signal:activate") for what counts as activation.
-- 
-- /Since: 4.14/
spinButtonSetActivatesDefault ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Bool
    -- ^ /@activatesDefault@/: 'P.True' to activate window’s default widget on activation
    -> m ()
spinButtonSetActivatesDefault spinButton activatesDefault = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let activatesDefault' = (P.fromIntegral . P.fromEnum) activatesDefault
    gtk_spin_button_set_activates_default spinButton' activatesDefault'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetActivatesDefaultMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetActivatesDefaultMethodInfo a signature where
    overloadedMethod = spinButtonSetActivatesDefault

instance O.OverloadedMethodInfo SpinButtonSetActivatesDefaultMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetActivatesDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetActivatesDefault"
        })


#endif

-- method SpinButton::set_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GtkAdjustment` to replace the existing adjustment"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_adjustment" gtk_spin_button_set_adjustment :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO ()

-- | Replaces the @GtkAdjustment@ associated with /@spinButton@/.
spinButtonSetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> b
    -- ^ /@adjustment@/: a @GtkAdjustment@ to replace the existing adjustment
    -> m ()
spinButtonSetAdjustment spinButton adjustment = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    adjustment' <- unsafeManagedPtrCastPtr adjustment
    gtk_spin_button_set_adjustment spinButton' adjustment'
    touchManagedPtr spinButton
    touchManagedPtr adjustment
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetAdjustmentMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsSpinButton a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod SpinButtonSetAdjustmentMethodInfo a signature where
    overloadedMethod = spinButtonSetAdjustment

instance O.OverloadedMethodInfo SpinButtonSetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetAdjustment"
        })


#endif

-- method SpinButton::set_climb_rate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "climb_rate"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the rate of acceleration, must be >= 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_climb_rate" gtk_spin_button_set_climb_rate :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CDouble ->                              -- climb_rate : TBasicType TDouble
    IO ()

-- | Sets the acceleration rate for repeated changes when you
-- hold down a button or key.
spinButtonSetClimbRate ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Double
    -- ^ /@climbRate@/: the rate of acceleration, must be >= 0
    -> m ()
spinButtonSetClimbRate spinButton climbRate = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let climbRate' = realToFrac climbRate
    gtk_spin_button_set_climb_rate spinButton' climbRate'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetClimbRateMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetClimbRateMethodInfo a signature where
    overloadedMethod = spinButtonSetClimbRate

instance O.OverloadedMethodInfo SpinButtonSetClimbRateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetClimbRate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetClimbRate"
        })


#endif

-- method SpinButton::set_digits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "digits"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of digits after the decimal point to be\n  displayed for the spin button\8217s value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_digits" gtk_spin_button_set_digits :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    Word32 ->                               -- digits : TBasicType TUInt
    IO ()

-- | Set the precision to be displayed by /@spinButton@/.
-- 
-- Up to 20 digit precision is allowed.
spinButtonSetDigits ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Word32
    -- ^ /@digits@/: the number of digits after the decimal point to be
    --   displayed for the spin button’s value
    -> m ()
spinButtonSetDigits spinButton digits = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    gtk_spin_button_set_digits spinButton' digits
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetDigitsMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetDigitsMethodInfo a signature where
    overloadedMethod = spinButtonSetDigits

instance O.OverloadedMethodInfo SpinButtonSetDigitsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetDigits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetDigits"
        })


#endif

-- method SpinButton::set_increments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "step"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "increment applied for a button 1 press."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "increment applied for a button 2 press."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_increments" gtk_spin_button_set_increments :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CDouble ->                              -- step : TBasicType TDouble
    CDouble ->                              -- page : TBasicType TDouble
    IO ()

-- | Sets the step and page increments for spin_button.
-- 
-- This affects how quickly the value changes when
-- the spin button’s arrows are activated.
spinButtonSetIncrements ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Double
    -- ^ /@step@/: increment applied for a button 1 press.
    -> Double
    -- ^ /@page@/: increment applied for a button 2 press.
    -> m ()
spinButtonSetIncrements spinButton step page = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let step' = realToFrac step
    let page' = realToFrac page
    gtk_spin_button_set_increments spinButton' step' page'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetIncrementsMethodInfo
instance (signature ~ (Double -> Double -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetIncrementsMethodInfo a signature where
    overloadedMethod = spinButtonSetIncrements

instance O.OverloadedMethodInfo SpinButtonSetIncrementsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetIncrements",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetIncrements"
        })


#endif

-- method SpinButton::set_numeric
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "numeric"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "flag indicating if only numeric entry is allowed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_numeric" gtk_spin_button_set_numeric :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CInt ->                                 -- numeric : TBasicType TBoolean
    IO ()

-- | Sets the flag that determines if non-numeric text can be typed
-- into the spin button.
spinButtonSetNumeric ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Bool
    -- ^ /@numeric@/: flag indicating if only numeric entry is allowed
    -> m ()
spinButtonSetNumeric spinButton numeric = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let numeric' = (P.fromIntegral . P.fromEnum) numeric
    gtk_spin_button_set_numeric spinButton' numeric'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetNumericMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetNumericMethodInfo a signature where
    overloadedMethod = spinButtonSetNumeric

instance O.OverloadedMethodInfo SpinButtonSetNumericMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetNumeric",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetNumeric"
        })


#endif

-- method SpinButton::set_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum allowable value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum allowable value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_range" gtk_spin_button_set_range :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CDouble ->                              -- min : TBasicType TDouble
    CDouble ->                              -- max : TBasicType TDouble
    IO ()

-- | Sets the minimum and maximum allowable values for /@spinButton@/.
-- 
-- If the current value is outside this range, it will be adjusted
-- to fit within the range, otherwise it will remain unchanged.
spinButtonSetRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Double
    -- ^ /@min@/: minimum allowable value
    -> Double
    -- ^ /@max@/: maximum allowable value
    -> m ()
spinButtonSetRange spinButton min max = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let min' = realToFrac min
    let max' = realToFrac max
    gtk_spin_button_set_range spinButton' min' max'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetRangeMethodInfo
instance (signature ~ (Double -> Double -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetRangeMethodInfo a signature where
    overloadedMethod = spinButtonSetRange

instance O.OverloadedMethodInfo SpinButtonSetRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetRange"
        })


#endif

-- method SpinButton::set_snap_to_ticks
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "snap_to_ticks"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a flag indicating if invalid values should be corrected"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_snap_to_ticks" gtk_spin_button_set_snap_to_ticks :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CInt ->                                 -- snap_to_ticks : TBasicType TBoolean
    IO ()

-- | Sets the policy as to whether values are corrected to the
-- nearest step increment when a spin button is activated after
-- providing an invalid value.
spinButtonSetSnapToTicks ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Bool
    -- ^ /@snapToTicks@/: a flag indicating if invalid values should be corrected
    -> m ()
spinButtonSetSnapToTicks spinButton snapToTicks = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let snapToTicks' = (P.fromIntegral . P.fromEnum) snapToTicks
    gtk_spin_button_set_snap_to_ticks spinButton' snapToTicks'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetSnapToTicksMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetSnapToTicksMethodInfo a signature where
    overloadedMethod = spinButtonSetSnapToTicks

instance O.OverloadedMethodInfo SpinButtonSetSnapToTicksMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetSnapToTicks",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetSnapToTicks"
        })


#endif

-- method SpinButton::set_update_policy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "policy"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "SpinButtonUpdatePolicy" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButtonUpdatePolicy` value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_update_policy" gtk_spin_button_set_update_policy :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CUInt ->                                -- policy : TInterface (Name {namespace = "Gtk", name = "SpinButtonUpdatePolicy"})
    IO ()

-- | Sets the update behavior of a spin button.
-- 
-- This determines whether the spin button is always
-- updated or only when a valid value is set.
spinButtonSetUpdatePolicy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Gtk.Enums.SpinButtonUpdatePolicy
    -- ^ /@policy@/: a @GtkSpinButtonUpdatePolicy@ value
    -> m ()
spinButtonSetUpdatePolicy spinButton policy = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let policy' = (fromIntegral . fromEnum) policy
    gtk_spin_button_set_update_policy spinButton' policy'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetUpdatePolicyMethodInfo
instance (signature ~ (Gtk.Enums.SpinButtonUpdatePolicy -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetUpdatePolicyMethodInfo a signature where
    overloadedMethod = spinButtonSetUpdatePolicy

instance O.OverloadedMethodInfo SpinButtonSetUpdatePolicyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetUpdatePolicy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetUpdatePolicy"
        })


#endif

-- method SpinButton::set_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_value" gtk_spin_button_set_value :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Sets the value of /@spinButton@/.
spinButtonSetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Double
    -- ^ /@value@/: the new value
    -> m ()
spinButtonSetValue spinButton value = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let value' = realToFrac value
    gtk_spin_button_set_value spinButton' value'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetValueMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetValueMethodInfo a signature where
    overloadedMethod = spinButtonSetValue

instance O.OverloadedMethodInfo SpinButtonSetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetValue"
        })


#endif

-- method SpinButton::set_wrap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wrap"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a flag indicating if wrapping behavior is performed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_set_wrap" gtk_spin_button_set_wrap :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CInt ->                                 -- wrap : TBasicType TBoolean
    IO ()

-- | Sets the flag that determines if a spin button value wraps
-- around to the opposite limit when the upper or lower limit
-- of the range is exceeded.
spinButtonSetWrap ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Bool
    -- ^ /@wrap@/: a flag indicating if wrapping behavior is performed
    -> m ()
spinButtonSetWrap spinButton wrap = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let wrap' = (P.fromIntegral . P.fromEnum) wrap
    gtk_spin_button_set_wrap spinButton' wrap'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSetWrapMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSetWrapMethodInfo a signature where
    overloadedMethod = spinButtonSetWrap

instance O.OverloadedMethodInfo SpinButtonSetWrapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSetWrap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSetWrap"
        })


#endif

-- method SpinButton::spin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GtkSpinType` indicating the direction to spin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "increment"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "step increment to apply in the specified direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_spin" gtk_spin_button_spin :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    CUInt ->                                -- direction : TInterface (Name {namespace = "Gtk", name = "SpinType"})
    CDouble ->                              -- increment : TBasicType TDouble
    IO ()

-- | Increment or decrement a spin button’s value in a specified
-- direction by a specified amount.
spinButtonSpin ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> Gtk.Enums.SpinType
    -- ^ /@direction@/: a @GtkSpinType@ indicating the direction to spin
    -> Double
    -- ^ /@increment@/: step increment to apply in the specified direction
    -> m ()
spinButtonSpin spinButton direction increment = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    let direction' = (fromIntegral . fromEnum) direction
    let increment' = realToFrac increment
    gtk_spin_button_spin spinButton' direction' increment'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonSpinMethodInfo
instance (signature ~ (Gtk.Enums.SpinType -> Double -> m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonSpinMethodInfo a signature where
    overloadedMethod = spinButtonSpin

instance O.OverloadedMethodInfo SpinButtonSpinMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonSpin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonSpin"
        })


#endif

-- method SpinButton::update
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "spin_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SpinButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSpinButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_spin_button_update" gtk_spin_button_update :: 
    Ptr SpinButton ->                       -- spin_button : TInterface (Name {namespace = "Gtk", name = "SpinButton"})
    IO ()

-- | Manually force an update of the spin button.
spinButtonUpdate ::
    (B.CallStack.HasCallStack, MonadIO m, IsSpinButton a) =>
    a
    -- ^ /@spinButton@/: a @GtkSpinButton@
    -> m ()
spinButtonUpdate spinButton = liftIO $ do
    spinButton' <- unsafeManagedPtrCastPtr spinButton
    gtk_spin_button_update spinButton'
    touchManagedPtr spinButton
    return ()

#if defined(ENABLE_OVERLOADING)
data SpinButtonUpdateMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSpinButton a) => O.OverloadedMethod SpinButtonUpdateMethodInfo a signature where
    overloadedMethod = spinButtonUpdate

instance O.OverloadedMethodInfo SpinButtonUpdateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SpinButton.spinButtonUpdate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SpinButton.html#v:spinButtonUpdate"
        })


#endif


