{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The kind of widget that can be added to a @GtkListBox@.
-- 
-- t'GI.Gtk.Objects.ListBox.ListBox' will automatically wrap its children in a @GtkListboxRow@
-- when necessary.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ListBoxRow
    ( 

-- * Exported types
    ListBoxRow(..)                          ,
    IsListBoxRow                            ,
    toListBoxRow                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.ListBoxRow#g:method:changed"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSelected]("GI.Gtk.Objects.ListBoxRow#g:method:isSelected"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActionName]("GI.Gtk.Interfaces.Actionable#g:method:getActionName"), [getActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:getActionTargetValue"), [getActivatable]("GI.Gtk.Objects.ListBoxRow#g:method:getActivatable"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.ListBoxRow#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeader]("GI.Gtk.Objects.ListBoxRow#g:method:getHeader"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIndex]("GI.Gtk.Objects.ListBoxRow#g:method:getIndex"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectable]("GI.Gtk.Objects.ListBoxRow#g:method:getSelectable"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActionName]("GI.Gtk.Interfaces.Actionable#g:method:setActionName"), [setActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:setActionTargetValue"), [setActivatable]("GI.Gtk.Objects.ListBoxRow#g:method:setActivatable"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.ListBoxRow#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDetailedActionName]("GI.Gtk.Interfaces.Actionable#g:method:setDetailedActionName"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHeader]("GI.Gtk.Objects.ListBoxRow#g:method:setHeader"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSelectable]("GI.Gtk.Objects.ListBoxRow#g:method:setSelectable"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveListBoxRowMethod                 ,
#endif

-- ** changed #method:changed#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowChangedMethodInfo             ,
#endif
    listBoxRowChanged                       ,


-- ** getActivatable #method:getActivatable#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowGetActivatableMethodInfo      ,
#endif
    listBoxRowGetActivatable                ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowGetChildMethodInfo            ,
#endif
    listBoxRowGetChild                      ,


-- ** getHeader #method:getHeader#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowGetHeaderMethodInfo           ,
#endif
    listBoxRowGetHeader                     ,


-- ** getIndex #method:getIndex#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowGetIndexMethodInfo            ,
#endif
    listBoxRowGetIndex                      ,


-- ** getSelectable #method:getSelectable#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowGetSelectableMethodInfo       ,
#endif
    listBoxRowGetSelectable                 ,


-- ** isSelected #method:isSelected#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowIsSelectedMethodInfo          ,
#endif
    listBoxRowIsSelected                    ,


-- ** new #method:new#

    listBoxRowNew                           ,


-- ** setActivatable #method:setActivatable#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowSetActivatableMethodInfo      ,
#endif
    listBoxRowSetActivatable                ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowSetChildMethodInfo            ,
#endif
    listBoxRowSetChild                      ,


-- ** setHeader #method:setHeader#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowSetHeaderMethodInfo           ,
#endif
    listBoxRowSetHeader                     ,


-- ** setSelectable #method:setSelectable#

#if defined(ENABLE_OVERLOADING)
    ListBoxRowSetSelectableMethodInfo       ,
#endif
    listBoxRowSetSelectable                 ,




 -- * Properties


-- ** activatable #attr:activatable#
-- | Determines whether the [rowActivated](#g:signal:rowActivated)
-- signal will be emitted for this row.

#if defined(ENABLE_OVERLOADING)
    ListBoxRowActivatablePropertyInfo       ,
#endif
    constructListBoxRowActivatable          ,
    getListBoxRowActivatable                ,
#if defined(ENABLE_OVERLOADING)
    listBoxRowActivatable                   ,
#endif
    setListBoxRowActivatable                ,


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    ListBoxRowChildPropertyInfo             ,
#endif
    clearListBoxRowChild                    ,
    constructListBoxRowChild                ,
    getListBoxRowChild                      ,
#if defined(ENABLE_OVERLOADING)
    listBoxRowChild                         ,
#endif
    setListBoxRowChild                      ,


-- ** selectable #attr:selectable#
-- | Determines whether this row can be selected.

#if defined(ENABLE_OVERLOADING)
    ListBoxRowSelectablePropertyInfo        ,
#endif
    constructListBoxRowSelectable           ,
    getListBoxRowSelectable                 ,
#if defined(ENABLE_OVERLOADING)
    listBoxRowSelectable                    ,
#endif
    setListBoxRowSelectable                 ,




 -- * Signals


-- ** activate #signal:activate#

    ListBoxRowActivateCallback              ,
#if defined(ENABLE_OVERLOADING)
    ListBoxRowActivateSignalInfo            ,
#endif
    afterListBoxRowActivate                 ,
    onListBoxRowActivate                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ListBoxRow = ListBoxRow (SP.ManagedPtr ListBoxRow)
    deriving (Eq)

instance SP.ManagedPtrNewtype ListBoxRow where
    toManagedPtr (ListBoxRow p) = p

foreign import ccall "gtk_list_box_row_get_type"
    c_gtk_list_box_row_get_type :: IO B.Types.GType

instance B.Types.TypedObject ListBoxRow where
    glibType = c_gtk_list_box_row_get_type

instance B.Types.GObject ListBoxRow

-- | Type class for types which can be safely cast to t'ListBoxRow', for instance with `toListBoxRow`.
class (SP.GObject o, O.IsDescendantOf ListBoxRow o) => IsListBoxRow o
instance (SP.GObject o, O.IsDescendantOf ListBoxRow o) => IsListBoxRow o

instance O.HasParentTypes ListBoxRow
type instance O.ParentTypes ListBoxRow = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Actionable.Actionable, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ListBoxRow', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toListBoxRow :: (MIO.MonadIO m, IsListBoxRow o) => o -> m ListBoxRow
toListBoxRow = MIO.liftIO . B.ManagedPtr.unsafeCastTo ListBoxRow

-- | Convert t'ListBoxRow' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ListBoxRow) where
    gvalueGType_ = c_gtk_list_box_row_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ListBoxRow)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ListBoxRow)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ListBoxRow ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveListBoxRowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveListBoxRowMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveListBoxRowMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveListBoxRowMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveListBoxRowMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveListBoxRowMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveListBoxRowMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveListBoxRowMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveListBoxRowMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveListBoxRowMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveListBoxRowMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveListBoxRowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveListBoxRowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveListBoxRowMethod "changed" o = ListBoxRowChangedMethodInfo
    ResolveListBoxRowMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveListBoxRowMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveListBoxRowMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveListBoxRowMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveListBoxRowMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveListBoxRowMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveListBoxRowMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveListBoxRowMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveListBoxRowMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveListBoxRowMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveListBoxRowMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveListBoxRowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveListBoxRowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveListBoxRowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveListBoxRowMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveListBoxRowMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveListBoxRowMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveListBoxRowMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveListBoxRowMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveListBoxRowMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveListBoxRowMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveListBoxRowMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveListBoxRowMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveListBoxRowMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveListBoxRowMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveListBoxRowMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveListBoxRowMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveListBoxRowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveListBoxRowMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveListBoxRowMethod "isSelected" o = ListBoxRowIsSelectedMethodInfo
    ResolveListBoxRowMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveListBoxRowMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveListBoxRowMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveListBoxRowMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveListBoxRowMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveListBoxRowMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveListBoxRowMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveListBoxRowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveListBoxRowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveListBoxRowMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveListBoxRowMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveListBoxRowMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveListBoxRowMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveListBoxRowMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveListBoxRowMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveListBoxRowMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveListBoxRowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveListBoxRowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveListBoxRowMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveListBoxRowMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveListBoxRowMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveListBoxRowMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveListBoxRowMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveListBoxRowMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveListBoxRowMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveListBoxRowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveListBoxRowMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveListBoxRowMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveListBoxRowMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveListBoxRowMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveListBoxRowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveListBoxRowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveListBoxRowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveListBoxRowMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveListBoxRowMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveListBoxRowMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveListBoxRowMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveListBoxRowMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveListBoxRowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveListBoxRowMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveListBoxRowMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveListBoxRowMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveListBoxRowMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveListBoxRowMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveListBoxRowMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveListBoxRowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveListBoxRowMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveListBoxRowMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveListBoxRowMethod "getActionName" o = Gtk.Actionable.ActionableGetActionNameMethodInfo
    ResolveListBoxRowMethod "getActionTargetValue" o = Gtk.Actionable.ActionableGetActionTargetValueMethodInfo
    ResolveListBoxRowMethod "getActivatable" o = ListBoxRowGetActivatableMethodInfo
    ResolveListBoxRowMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveListBoxRowMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveListBoxRowMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveListBoxRowMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveListBoxRowMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveListBoxRowMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveListBoxRowMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveListBoxRowMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveListBoxRowMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveListBoxRowMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveListBoxRowMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveListBoxRowMethod "getChild" o = ListBoxRowGetChildMethodInfo
    ResolveListBoxRowMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveListBoxRowMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveListBoxRowMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveListBoxRowMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveListBoxRowMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveListBoxRowMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveListBoxRowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveListBoxRowMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveListBoxRowMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveListBoxRowMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveListBoxRowMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveListBoxRowMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveListBoxRowMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveListBoxRowMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveListBoxRowMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveListBoxRowMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveListBoxRowMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveListBoxRowMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveListBoxRowMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveListBoxRowMethod "getHeader" o = ListBoxRowGetHeaderMethodInfo
    ResolveListBoxRowMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveListBoxRowMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveListBoxRowMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveListBoxRowMethod "getIndex" o = ListBoxRowGetIndexMethodInfo
    ResolveListBoxRowMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveListBoxRowMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveListBoxRowMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveListBoxRowMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveListBoxRowMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveListBoxRowMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveListBoxRowMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveListBoxRowMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveListBoxRowMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveListBoxRowMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveListBoxRowMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveListBoxRowMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveListBoxRowMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveListBoxRowMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveListBoxRowMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveListBoxRowMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveListBoxRowMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveListBoxRowMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveListBoxRowMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveListBoxRowMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveListBoxRowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveListBoxRowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveListBoxRowMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveListBoxRowMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveListBoxRowMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveListBoxRowMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveListBoxRowMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveListBoxRowMethod "getSelectable" o = ListBoxRowGetSelectableMethodInfo
    ResolveListBoxRowMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveListBoxRowMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveListBoxRowMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveListBoxRowMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveListBoxRowMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveListBoxRowMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveListBoxRowMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveListBoxRowMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveListBoxRowMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveListBoxRowMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveListBoxRowMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveListBoxRowMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveListBoxRowMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveListBoxRowMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveListBoxRowMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveListBoxRowMethod "setActionName" o = Gtk.Actionable.ActionableSetActionNameMethodInfo
    ResolveListBoxRowMethod "setActionTargetValue" o = Gtk.Actionable.ActionableSetActionTargetValueMethodInfo
    ResolveListBoxRowMethod "setActivatable" o = ListBoxRowSetActivatableMethodInfo
    ResolveListBoxRowMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveListBoxRowMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveListBoxRowMethod "setChild" o = ListBoxRowSetChildMethodInfo
    ResolveListBoxRowMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveListBoxRowMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveListBoxRowMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveListBoxRowMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveListBoxRowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveListBoxRowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveListBoxRowMethod "setDetailedActionName" o = Gtk.Actionable.ActionableSetDetailedActionNameMethodInfo
    ResolveListBoxRowMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveListBoxRowMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveListBoxRowMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveListBoxRowMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveListBoxRowMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveListBoxRowMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveListBoxRowMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveListBoxRowMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveListBoxRowMethod "setHeader" o = ListBoxRowSetHeaderMethodInfo
    ResolveListBoxRowMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveListBoxRowMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveListBoxRowMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveListBoxRowMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveListBoxRowMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveListBoxRowMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveListBoxRowMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveListBoxRowMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveListBoxRowMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveListBoxRowMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveListBoxRowMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveListBoxRowMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveListBoxRowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveListBoxRowMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveListBoxRowMethod "setSelectable" o = ListBoxRowSetSelectableMethodInfo
    ResolveListBoxRowMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveListBoxRowMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveListBoxRowMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveListBoxRowMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveListBoxRowMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveListBoxRowMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveListBoxRowMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveListBoxRowMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveListBoxRowMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveListBoxRowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveListBoxRowMethod t ListBoxRow, O.OverloadedMethod info ListBoxRow p) => OL.IsLabel t (ListBoxRow -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveListBoxRowMethod t ListBoxRow, O.OverloadedMethod info ListBoxRow p, R.HasField t ListBoxRow p) => R.HasField t ListBoxRow p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveListBoxRowMethod t ListBoxRow, O.OverloadedMethodInfo info ListBoxRow) => OL.IsLabel t (O.MethodProxy info ListBoxRow) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ListBoxRow::activate
-- | This is a keybinding signal, which will cause this row to be activated.
-- 
-- If you want to be notified when the user activates a row (by key or not),
-- use the [ListBox::rowActivated]("GI.Gtk.Objects.ListBox#g:signal:rowActivated") signal on the row’s parent
-- @GtkListBox@.
type ListBoxRowActivateCallback =
    IO ()

type C_ListBoxRowActivateCallback =
    Ptr ListBoxRow ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxRowActivateCallback`.
foreign import ccall "wrapper"
    mk_ListBoxRowActivateCallback :: C_ListBoxRowActivateCallback -> IO (FunPtr C_ListBoxRowActivateCallback)

wrap_ListBoxRowActivateCallback :: 
    GObject a => (a -> ListBoxRowActivateCallback) ->
    C_ListBoxRowActivateCallback
wrap_ListBoxRowActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBoxRow #activate callback
-- @
-- 
-- 
onListBoxRowActivate :: (IsListBoxRow a, MonadIO m) => a -> ((?self :: a) => ListBoxRowActivateCallback) -> m SignalHandlerId
onListBoxRowActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxRowActivateCallback wrapped
    wrapped'' <- mk_ListBoxRowActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBoxRow #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxRowActivate :: (IsListBoxRow a, MonadIO m) => a -> ((?self :: a) => ListBoxRowActivateCallback) -> m SignalHandlerId
afterListBoxRowActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxRowActivateCallback wrapped
    wrapped'' <- mk_ListBoxRowActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxRowActivateSignalInfo
instance SignalInfo ListBoxRowActivateSignalInfo where
    type HaskellCallbackType ListBoxRowActivateSignalInfo = ListBoxRowActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxRowActivateCallback cb
        cb'' <- mk_ListBoxRowActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#g:signal:activate"})

#endif

-- VVV Prop "activatable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@activatable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBoxRow #activatable
-- @
getListBoxRowActivatable :: (MonadIO m, IsListBoxRow o) => o -> m Bool
getListBoxRowActivatable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "activatable"

-- | Set the value of the “@activatable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBoxRow [ #activatable 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxRowActivatable :: (MonadIO m, IsListBoxRow o) => o -> Bool -> m ()
setListBoxRowActivatable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "activatable" val

-- | Construct a t'GValueConstruct' with valid value for the “@activatable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxRowActivatable :: (IsListBoxRow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListBoxRowActivatable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "activatable" val

#if defined(ENABLE_OVERLOADING)
data ListBoxRowActivatablePropertyInfo
instance AttrInfo ListBoxRowActivatablePropertyInfo where
    type AttrAllowedOps ListBoxRowActivatablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ListBoxRowActivatablePropertyInfo = IsListBoxRow
    type AttrSetTypeConstraint ListBoxRowActivatablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListBoxRowActivatablePropertyInfo = (~) Bool
    type AttrTransferType ListBoxRowActivatablePropertyInfo = Bool
    type AttrGetType ListBoxRowActivatablePropertyInfo = Bool
    type AttrLabel ListBoxRowActivatablePropertyInfo = "activatable"
    type AttrOrigin ListBoxRowActivatablePropertyInfo = ListBoxRow
    attrGet = getListBoxRowActivatable
    attrSet = setListBoxRowActivatable
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxRowActivatable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.activatable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#g:attr:activatable"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBoxRow #child
-- @
getListBoxRowChild :: (MonadIO m, IsListBoxRow o) => o -> m (Maybe Gtk.Widget.Widget)
getListBoxRowChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBoxRow [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxRowChild :: (MonadIO m, IsListBoxRow o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setListBoxRowChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxRowChild :: (IsListBoxRow o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructListBoxRowChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearListBoxRowChild :: (MonadIO m, IsListBoxRow o) => o -> m ()
clearListBoxRowChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ListBoxRowChildPropertyInfo
instance AttrInfo ListBoxRowChildPropertyInfo where
    type AttrAllowedOps ListBoxRowChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ListBoxRowChildPropertyInfo = IsListBoxRow
    type AttrSetTypeConstraint ListBoxRowChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ListBoxRowChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ListBoxRowChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ListBoxRowChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ListBoxRowChildPropertyInfo = "child"
    type AttrOrigin ListBoxRowChildPropertyInfo = ListBoxRow
    attrGet = getListBoxRowChild
    attrSet = setListBoxRowChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructListBoxRowChild
    attrClear = clearListBoxRowChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#g:attr:child"
        })
#endif

-- VVV Prop "selectable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@selectable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBoxRow #selectable
-- @
getListBoxRowSelectable :: (MonadIO m, IsListBoxRow o) => o -> m Bool
getListBoxRowSelectable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "selectable"

-- | Set the value of the “@selectable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBoxRow [ #selectable 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxRowSelectable :: (MonadIO m, IsListBoxRow o) => o -> Bool -> m ()
setListBoxRowSelectable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "selectable" val

-- | Construct a t'GValueConstruct' with valid value for the “@selectable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxRowSelectable :: (IsListBoxRow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListBoxRowSelectable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "selectable" val

#if defined(ENABLE_OVERLOADING)
data ListBoxRowSelectablePropertyInfo
instance AttrInfo ListBoxRowSelectablePropertyInfo where
    type AttrAllowedOps ListBoxRowSelectablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ListBoxRowSelectablePropertyInfo = IsListBoxRow
    type AttrSetTypeConstraint ListBoxRowSelectablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListBoxRowSelectablePropertyInfo = (~) Bool
    type AttrTransferType ListBoxRowSelectablePropertyInfo = Bool
    type AttrGetType ListBoxRowSelectablePropertyInfo = Bool
    type AttrLabel ListBoxRowSelectablePropertyInfo = "selectable"
    type AttrOrigin ListBoxRowSelectablePropertyInfo = ListBoxRow
    attrGet = getListBoxRowSelectable
    attrSet = setListBoxRowSelectable
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxRowSelectable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.selectable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#g:attr:selectable"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ListBoxRow
type instance O.AttributeList ListBoxRow = ListBoxRowAttributeList
type ListBoxRowAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("actionName", Gtk.Actionable.ActionableActionNamePropertyInfo), '("actionTarget", Gtk.Actionable.ActionableActionTargetPropertyInfo), '("activatable", ListBoxRowActivatablePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", ListBoxRowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("selectable", ListBoxRowSelectablePropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
listBoxRowActivatable :: AttrLabelProxy "activatable"
listBoxRowActivatable = AttrLabelProxy

listBoxRowChild :: AttrLabelProxy "child"
listBoxRowChild = AttrLabelProxy

listBoxRowSelectable :: AttrLabelProxy "selectable"
listBoxRowSelectable = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ListBoxRow = ListBoxRowSignalList
type ListBoxRowSignalList = ('[ '("activate", ListBoxRowActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ListBoxRow::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ListBoxRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_new" gtk_list_box_row_new :: 
    IO (Ptr ListBoxRow)

-- | Creates a new @GtkListBoxRow@.
listBoxRowNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ListBoxRow
    -- ^ __Returns:__ a new @GtkListBoxRow@
listBoxRowNew  = liftIO $ do
    result <- gtk_list_box_row_new
    checkUnexpectedReturnNULL "listBoxRowNew" result
    result' <- (newObject ListBoxRow) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ListBoxRow::changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_changed" gtk_list_box_row_changed :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO ()

-- | Marks /@row@/ as changed, causing any state that depends on this
-- to be updated.
-- 
-- This affects sorting, filtering and headers.
-- 
-- Note that calls to this method must be in sync with the data
-- used for the row functions. For instance, if the list is
-- mirroring some external data set, and *two* rows changed in the
-- external data set then when you call 'GI.Gtk.Objects.ListBoxRow.listBoxRowChanged'
-- on the first row the sort function must only read the new data
-- for the first of the two changed rows, otherwise the resorting
-- of the rows will be wrong.
-- 
-- This generally means that if you don’t fully control the data
-- model you have to duplicate the data that affects the listbox
-- row functions into the row widgets themselves. Another alternative
-- is to call 'GI.Gtk.Objects.ListBox.listBoxInvalidateSort' on any model change,
-- but that is more expensive.
listBoxRowChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m ()
listBoxRowChanged row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    gtk_list_box_row_changed row'
    touchManagedPtr row
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRowChangedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowChangedMethodInfo a signature where
    overloadedMethod = listBoxRowChanged

instance O.OverloadedMethodInfo ListBoxRowChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowChanged"
        })


#endif

-- method ListBoxRow::get_activatable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_get_activatable" gtk_list_box_row_get_activatable :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO CInt

-- | Gets whether the row is activatable.
listBoxRowGetActivatable ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row is activatable
listBoxRowGetActivatable row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- gtk_list_box_row_get_activatable row'
    let result' = (/= 0) result
    touchManagedPtr row
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxRowGetActivatableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowGetActivatableMethodInfo a signature where
    overloadedMethod = listBoxRowGetActivatable

instance O.OverloadedMethodInfo ListBoxRowGetActivatableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowGetActivatable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowGetActivatable"
        })


#endif

-- method ListBoxRow::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_get_child" gtk_list_box_row_get_child :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@row@/.
listBoxRowGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@row@/
listBoxRowGetChild row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- gtk_list_box_row_get_child row'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr row
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListBoxRowGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowGetChildMethodInfo a signature where
    overloadedMethod = listBoxRowGetChild

instance O.OverloadedMethodInfo ListBoxRowGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowGetChild"
        })


#endif

-- method ListBoxRow::get_header
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_get_header" gtk_list_box_row_get_header :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the current header of the /@row@/.
-- 
-- This can be used
-- in a [callback/@gtk@/.ListBoxUpdateHeaderFunc] to see if
-- there is a header set already, and if so to update
-- the state of it.
listBoxRowGetHeader ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the current header
listBoxRowGetHeader row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- gtk_list_box_row_get_header row'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr row
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListBoxRowGetHeaderMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowGetHeaderMethodInfo a signature where
    overloadedMethod = listBoxRowGetHeader

instance O.OverloadedMethodInfo ListBoxRowGetHeaderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowGetHeader",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowGetHeader"
        })


#endif

-- method ListBoxRow::get_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_get_index" gtk_list_box_row_get_index :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO Int32

-- | Gets the current index of the /@row@/ in its @GtkListBox@ container.
listBoxRowGetIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m Int32
    -- ^ __Returns:__ the index of the /@row@/, or -1 if the /@row@/ is not in a listbox
listBoxRowGetIndex row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- gtk_list_box_row_get_index row'
    touchManagedPtr row
    return result

#if defined(ENABLE_OVERLOADING)
data ListBoxRowGetIndexMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowGetIndexMethodInfo a signature where
    overloadedMethod = listBoxRowGetIndex

instance O.OverloadedMethodInfo ListBoxRowGetIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowGetIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowGetIndex"
        })


#endif

-- method ListBoxRow::get_selectable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_get_selectable" gtk_list_box_row_get_selectable :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO CInt

-- | Gets whether the row can be selected.
listBoxRowGetSelectable ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row is selectable
listBoxRowGetSelectable row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- gtk_list_box_row_get_selectable row'
    let result' = (/= 0) result
    touchManagedPtr row
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxRowGetSelectableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowGetSelectableMethodInfo a signature where
    overloadedMethod = listBoxRowGetSelectable

instance O.OverloadedMethodInfo ListBoxRowGetSelectableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowGetSelectable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowGetSelectable"
        })


#endif

-- method ListBoxRow::is_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_is_selected" gtk_list_box_row_is_selected :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO CInt

-- | Returns whether the child is currently selected in its
-- @GtkListBox@ container.
listBoxRowIsSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@row@/ is selected
listBoxRowIsSelected row = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- gtk_list_box_row_is_selected row'
    let result' = (/= 0) result
    touchManagedPtr row
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxRowIsSelectedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowIsSelectedMethodInfo a signature where
    overloadedMethod = listBoxRowIsSelected

instance O.OverloadedMethodInfo ListBoxRowIsSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowIsSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowIsSelected"
        })


#endif

-- method ListBoxRow::set_activatable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "activatable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to mark the row as activatable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_set_activatable" gtk_list_box_row_set_activatable :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    CInt ->                                 -- activatable : TBasicType TBoolean
    IO ()

-- | Set whether the row is activatable.
listBoxRowSetActivatable ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> Bool
    -- ^ /@activatable@/: 'P.True' to mark the row as activatable
    -> m ()
listBoxRowSetActivatable row activatable = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    let activatable' = (P.fromIntegral . P.fromEnum) activatable
    gtk_list_box_row_set_activatable row' activatable'
    touchManagedPtr row
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRowSetActivatableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowSetActivatableMethodInfo a signature where
    overloadedMethod = listBoxRowSetActivatable

instance O.OverloadedMethodInfo ListBoxRowSetActivatableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowSetActivatable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowSetActivatable"
        })


#endif

-- method ListBoxRow::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_set_child" gtk_list_box_row_set_child :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@self@/.
listBoxRowSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
listBoxRowSetChild row child = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_list_box_row_set_child row' maybeChild
    touchManagedPtr row
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRowSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListBoxRow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxRowSetChildMethodInfo a signature where
    overloadedMethod = listBoxRowSetChild

instance O.OverloadedMethodInfo ListBoxRowSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowSetChild"
        })


#endif

-- method ListBoxRow::set_header
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "header"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the header" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_set_header" gtk_list_box_row_set_header :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    Ptr Gtk.Widget.Widget ->                -- header : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the current header of the /@row@/.
-- 
-- This is only allowed to be called
-- from a [callback/@gtk@/.ListBoxUpdateHeaderFunc].
-- It will replace any existing header in the row,
-- and be shown in front of the row in the listbox.
listBoxRowSetHeader ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> Maybe (b)
    -- ^ /@header@/: the header
    -> m ()
listBoxRowSetHeader row header = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    maybeHeader <- case header of
        Nothing -> return FP.nullPtr
        Just jHeader -> do
            jHeader' <- unsafeManagedPtrCastPtr jHeader
            return jHeader'
    gtk_list_box_row_set_header row' maybeHeader
    touchManagedPtr row
    whenJust header touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRowSetHeaderMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListBoxRow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxRowSetHeaderMethodInfo a signature where
    overloadedMethod = listBoxRowSetHeader

instance O.OverloadedMethodInfo ListBoxRowSetHeaderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowSetHeader",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowSetHeader"
        })


#endif

-- method ListBoxRow::set_selectable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selectable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to mark the row as selectable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_row_set_selectable" gtk_list_box_row_set_selectable :: 
    Ptr ListBoxRow ->                       -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    CInt ->                                 -- selectable : TBasicType TBoolean
    IO ()

-- | Set whether the row can be selected.
listBoxRowSetSelectable ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBoxRow a) =>
    a
    -- ^ /@row@/: a @GtkListBoxRow@
    -> Bool
    -- ^ /@selectable@/: 'P.True' to mark the row as selectable
    -> m ()
listBoxRowSetSelectable row selectable = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    let selectable' = (P.fromIntegral . P.fromEnum) selectable
    gtk_list_box_row_set_selectable row' selectable'
    touchManagedPtr row
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRowSetSelectableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListBoxRow a) => O.OverloadedMethod ListBoxRowSetSelectableMethodInfo a signature where
    overloadedMethod = listBoxRowSetSelectable

instance O.OverloadedMethodInfo ListBoxRowSetSelectableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBoxRow.listBoxRowSetSelectable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBoxRow.html#v:listBoxRowSetSelectable"
        })


#endif


