/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_protocol_formatter_async = R"doc(Uses a header format object to append a header onto a PDU.

This block takes in PDUs and creates a header, generally for MAC-level processing. Each received PDU is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


The header that is created and transmitted out of the 'header' message port as a PDU. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output PDU as a PMT argument along with any changes to the metadata info PMT.


For different packet header formatting needs, we can define new classes that inherit from the header_format_base block and which overload the header_format_base::format function.





This block only uses asynchronous message passing interfaces to receiver and emit PDUs. The message ports are:

Constructor Specific Documentation:

Make a packet header block using a given .

Args:
    format : The format object to use when creating the header for the packet.)doc";


static const char* __doc_gr_digital_protocol_formatter_async_protocol_formatter_async =
    R"doc()doc";


static const char* __doc_gr_digital_protocol_formatter_async_make = R"doc(Uses a header format object to append a header onto a PDU.

This block takes in PDUs and creates a header, generally for MAC-level processing. Each received PDU is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


The header that is created and transmitted out of the 'header' message port as a PDU. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output PDU as a PMT argument along with any changes to the metadata info PMT.


For different packet header formatting needs, we can define new classes that inherit from the header_format_base block and which overload the header_format_base::format function.





This block only uses asynchronous message passing interfaces to receiver and emit PDUs. The message ports are:

Constructor Specific Documentation:

Make a packet header block using a given .

Args:
    format : The format object to use when creating the header for the packet.)doc";
