/* THIS FILE IS AUTOGENERATED FROM KeyAlgorithm.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "KeyAlgorithmBinding.h"
#include "MainThreadUtils.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsfriendapi.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



KeyAlgorithm::KeyAlgorithm()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
KeyAlgorithm::InitIds(JSContext* cx, KeyAlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
KeyAlgorithm::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
KeyAlgorithm::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  KeyAlgorithmAtoms* atomsCache = GetAtomCache<KeyAlgorithmAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
KeyAlgorithm::TraceDictionary(JSTracer* trc)
{
}

KeyAlgorithm&
KeyAlgorithm::operator=(const KeyAlgorithm& aOther)
{
  DictionaryBase::operator=(aOther);
  mName = aOther.mName;
  return *this;
}



AesKeyAlgorithm::AesKeyAlgorithm()
  : KeyAlgorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
AesKeyAlgorithm::InitIds(JSContext* cx, AesKeyAlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length")) {
    return false;
  }
  return true;
}

bool
AesKeyAlgorithm::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!KeyAlgorithm::Init()) {
    return false;
  }

  return true;
}

bool
AesKeyAlgorithm::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  AesKeyAlgorithmAtoms* atomsCache = GetAtomCache<AesKeyAlgorithmAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!KeyAlgorithm::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint16_t const & currentValue = mLength;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->length_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
AesKeyAlgorithm::TraceDictionary(JSTracer* trc)
{
  KeyAlgorithm::TraceDictionary(trc);
}

AesKeyAlgorithm&
AesKeyAlgorithm::operator=(const AesKeyAlgorithm& aOther)
{
  KeyAlgorithm::operator=(aOther);
  mLength = aOther.mLength;
  return *this;
}



DhKeyAlgorithm::DhKeyAlgorithm()
  : KeyAlgorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}



bool
DhKeyAlgorithm::InitIds(JSContext* cx, DhKeyAlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->prime_id.init(cx, "prime") ||
      !atomsCache->generator_id.init(cx, "generator")) {
    return false;
  }
  return true;
}

bool
DhKeyAlgorithm::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!KeyAlgorithm::Init()) {
    return false;
  }

  return true;
}

bool
DhKeyAlgorithm::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DhKeyAlgorithmAtoms* atomsCache = GetAtomCache<DhKeyAlgorithmAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!KeyAlgorithm::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Uint8Array const & currentValue = mGenerator;
    temp.setObject(*currentValue.Obj());
    if (!MaybeWrapNonDOMObjectValue(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->generator_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Uint8Array const & currentValue = mPrime;
    temp.setObject(*currentValue.Obj());
    if (!MaybeWrapNonDOMObjectValue(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->prime_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
DhKeyAlgorithm::TraceDictionary(JSTracer* trc)
{
  KeyAlgorithm::TraceDictionary(trc);
  mGenerator.TraceSelf(trc);

  mPrime.TraceSelf(trc);
}



EcKeyAlgorithm::EcKeyAlgorithm()
  : KeyAlgorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
EcKeyAlgorithm::InitIds(JSContext* cx, EcKeyAlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->namedCurve_id.init(cx, "namedCurve")) {
    return false;
  }
  return true;
}

bool
EcKeyAlgorithm::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!KeyAlgorithm::Init()) {
    return false;
  }

  return true;
}

bool
EcKeyAlgorithm::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  EcKeyAlgorithmAtoms* atomsCache = GetAtomCache<EcKeyAlgorithmAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!KeyAlgorithm::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mNamedCurve;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->namedCurve_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
EcKeyAlgorithm::TraceDictionary(JSTracer* trc)
{
  KeyAlgorithm::TraceDictionary(trc);
}

EcKeyAlgorithm&
EcKeyAlgorithm::operator=(const EcKeyAlgorithm& aOther)
{
  KeyAlgorithm::operator=(aOther);
  mNamedCurve = aOther.mNamedCurve;
  return *this;
}



HmacKeyAlgorithm::HmacKeyAlgorithm()
  : KeyAlgorithm(FastDictionaryInitializer()),
    mHash(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HmacKeyAlgorithm::InitIds(JSContext* cx, HmacKeyAlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
HmacKeyAlgorithm::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!KeyAlgorithm::Init()) {
    return false;
  }

  return true;
}

bool
HmacKeyAlgorithm::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HmacKeyAlgorithmAtoms* atomsCache = GetAtomCache<HmacKeyAlgorithmAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!KeyAlgorithm::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    KeyAlgorithm const & currentValue = mHash;
    if (!currentValue.ToObjectInternal(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->hash_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mLength;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->length_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
HmacKeyAlgorithm::TraceDictionary(JSTracer* trc)
{
  KeyAlgorithm::TraceDictionary(trc);
}

HmacKeyAlgorithm&
HmacKeyAlgorithm::operator=(const HmacKeyAlgorithm& aOther)
{
  KeyAlgorithm::operator=(aOther);
  mHash = aOther.mHash;
  mLength = aOther.mLength;
  return *this;
}



RsaHashedKeyAlgorithm::RsaHashedKeyAlgorithm()
  : KeyAlgorithm(FastDictionaryInitializer()),
    mHash(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}



bool
RsaHashedKeyAlgorithm::InitIds(JSContext* cx, RsaHashedKeyAlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->publicExponent_id.init(cx, "publicExponent") ||
      !atomsCache->modulusLength_id.init(cx, "modulusLength") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
RsaHashedKeyAlgorithm::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!KeyAlgorithm::Init()) {
    return false;
  }

  return true;
}

bool
RsaHashedKeyAlgorithm::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RsaHashedKeyAlgorithmAtoms* atomsCache = GetAtomCache<RsaHashedKeyAlgorithmAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!KeyAlgorithm::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    KeyAlgorithm const & currentValue = mHash;
    if (!currentValue.ToObjectInternal(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->hash_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint16_t const & currentValue = mModulusLength;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->modulusLength_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Uint8Array const & currentValue = mPublicExponent;
    temp.setObject(*currentValue.Obj());
    if (!MaybeWrapNonDOMObjectValue(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->publicExponent_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RsaHashedKeyAlgorithm::TraceDictionary(JSTracer* trc)
{
  KeyAlgorithm::TraceDictionary(trc);
  mPublicExponent.TraceSelf(trc);
}


} // namespace mozilla::dom
