/* THIS FILE IS AUTOGENERATED FROM Console.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "ConsoleBinding.h"
#include "ConsoleInstanceBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/UseCounter.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Console.h"
#include "mozilla/dom/ConsoleInstance.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace console_Binding {

MOZ_CAN_RUN_SCRIPT static bool
_assert_(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "assert", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  bool arg0;
  if (args.hasDefined(0)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Argument 1", &arg0)) {
      return false;
    }
  } else {
    arg0 = false;
  }
  AutoSequence<JS::Value> arg1;
  SequenceRooter<JS::Value> arg1_holder(cx, &arg1);
  if (args.length() > 1) {
    if (!arg1.SetCapacity(args.length() - 1, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 1; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg1.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Assert(global, arg0, Constify(arg1)))>, "Should be returning void here");
  mozilla::dom::Console::Assert(global, arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_assert);

  } else {
    SetUseCounter(UseCounterWorker::console_assert);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
clear(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "clear", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Clear(global))>, "Should be returning void here");
  mozilla::dom::Console::Clear(global);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_clear);

  } else {
    SetUseCounter(UseCounterWorker::console_clear);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
count(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "count", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"default");
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Count(global, NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  mozilla::dom::Console::Count(global, NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_count);

  } else {
    SetUseCounter(UseCounterWorker::console_count);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
countReset(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "countReset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"default");
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::CountReset(global, NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  mozilla::dom::Console::CountReset(global, NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_countReset);

  } else {
    SetUseCounter(UseCounterWorker::console_countReset);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
debug(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "debug", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Debug(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Debug(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_debug);

  } else {
    SetUseCounter(UseCounterWorker::console_debug);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
error(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "error", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Error(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Error(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_error);

  } else {
    SetUseCounter(UseCounterWorker::console_error);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
info(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "info", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Info(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Info(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_info);

  } else {
    SetUseCounter(UseCounterWorker::console_info);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
log(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "log", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Log(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Log(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_log);

  } else {
    SetUseCounter(UseCounterWorker::console_log);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
table(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "table", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Table(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Table(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_table);

  } else {
    SetUseCounter(UseCounterWorker::console_table);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
trace(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "trace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Trace(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Trace(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_trace);

  } else {
    SetUseCounter(UseCounterWorker::console_trace);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
warn(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "warn", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Warn(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Warn(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_warn);

  } else {
    SetUseCounter(UseCounterWorker::console_warn);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dir(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "dir", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Dir(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Dir(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_dir);

  } else {
    SetUseCounter(UseCounterWorker::console_dir);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dirxml(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "dirxml", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Dirxml(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Dirxml(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_dirxml);

  } else {
    SetUseCounter(UseCounterWorker::console_dirxml);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
group(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "group", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Group(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Group(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_group);

  } else {
    SetUseCounter(UseCounterWorker::console_group);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
groupCollapsed(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "groupCollapsed", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::GroupCollapsed(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::GroupCollapsed(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_groupCollapsed);

  } else {
    SetUseCounter(UseCounterWorker::console_groupCollapsed);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
groupEnd(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "groupEnd", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::GroupEnd(global))>, "Should be returning void here");
  mozilla::dom::Console::GroupEnd(global);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_groupEnd);

  } else {
    SetUseCounter(UseCounterWorker::console_groupEnd);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
time(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "time", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"default");
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Time(global, NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  mozilla::dom::Console::Time(global, NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_time);

  } else {
    SetUseCounter(UseCounterWorker::console_time);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
timeLog(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "timeLog", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"default");
  }
  AutoSequence<JS::Value> arg1;
  SequenceRooter<JS::Value> arg1_holder(cx, &arg1);
  if (args.length() > 1) {
    if (!arg1.SetCapacity(args.length() - 1, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 1; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg1.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::TimeLog(global, NonNullHelper(Constify(arg0)), Constify(arg1)))>, "Should be returning void here");
  mozilla::dom::Console::TimeLog(global, NonNullHelper(Constify(arg0)), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_timeLog);

  } else {
    SetUseCounter(UseCounterWorker::console_timeLog);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
timeEnd(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "timeEnd", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral(u"default");
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::TimeEnd(global, NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  mozilla::dom::Console::TimeEnd(global, NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_timeEnd);

  } else {
    SetUseCounter(UseCounterWorker::console_timeEnd);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
exception(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "exception", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Exception(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Exception(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_exception);

  } else {
    SetUseCounter(UseCounterWorker::console_exception);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
timeStamp(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "timeStamp", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  JS::Rooted<JS::Value> arg0(cx);
  if (args.hasDefined(0)) {
    arg0 = args[0];
  } else {
    arg0 = JS::UndefinedValue();
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::TimeStamp(global, arg0))>, "Should be returning void here");
  mozilla::dom::Console::TimeStamp(global, arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_timeStamp);

  } else {
    SetUseCounter(UseCounterWorker::console_timeStamp);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
profile(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "profile", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::Profile(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::Profile(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_profile);

  } else {
    SetUseCounter(UseCounterWorker::console_profile);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
profileEnd(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "profileEnd", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::Console::ProfileEnd(global, Constify(arg0)))>, "Should be returning void here");
  mozilla::dom::Console::ProfileEnd(global, Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (NS_IsMainThread()) {
    SetUseCounter(obj, eUseCounter_console_profileEnd);

  } else {
    SetUseCounter(UseCounterWorker::console_profileEnd);

  }
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
createInstance(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "console.createInstance");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "console", "createInstance", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FastConsoleInstanceOptions arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::ConsoleInstance>(mozilla::dom::Console::CreateInstance(global, Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("assert", _assert_, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clear", clear, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("count", count, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("countReset", countReset, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("debug", debug, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("error", error, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("info", info, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("log", log, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("table", table, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("trace", trace, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("warn", warn, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dir", dir, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dirxml", dirxml, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("group", group, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("groupCollapsed", groupCollapsed, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("groupEnd", groupEnd, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("time", time, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("timeLog", timeLog, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("timeEnd", timeEnd, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("exception", exception, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("timeStamp", timeStamp, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("profile", profile, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("profileEnd", profileEnd, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(23 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeStaticMethods_specs[] = {
  JS_FNSPEC("createInstance", createInstance, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeStaticMethods[] = {
  { nullptr, &sChromeStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sChromeConstants_specs[] = {
  { "IS_NATIVE_CONSOLE", JS::BooleanValue(true) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sChromeConstants[] = {
  { nullptr, &sChromeConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[23];
static PropertyInfo sNativeProperties_propertyInfos[23];

static const NativePropertiesN<1> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  23,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(23 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[2];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[2];

static const NativePropertiesN<2> sChromeOnlyNativeProperties = {
  true,  0 /* sChromeStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  true,  1 /* sChromeConstants */,
  -1,
  2,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeStaticMethods, &sChromeOnlyNativeProperties_propertyInfos[0] },
    { sChromeConstants, &sChromeOnlyNativeProperties_propertyInfos[1] }
  }
};
static_assert(2 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::console,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "Console",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, GetHackedNamespaceProtoObject(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::console);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             sChromeOnlyNativeProperties.Upcast(),
                             "console",
                             aDefineOnGlobal != DefineInterfaceProperty::No);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::console,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace console_Binding



} // namespace mozilla::dom
