// This file is generated by kconfig_compiler_kf6 from easyeffects_db_graph.kcfg.
// All changes you do to this file will be lost.
#ifndef DBGRAPH_H
#define DBGRAPH_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <qqmlintegration.h>

class QQmlEngine;
class QJSEngine;

class DbGraph : public KConfigBaseEE
{
  Q_OBJECT
  QML_ELEMENT
  QML_SINGLETON
  public:
    class EnumColorScheme
    {
      public:
      enum type { automatic, light, dark, COUNT };
    };
    class EnumColorTheme
    {
      public:
      enum type { qtGreen, qtGreenNeon, mixSeries, orangeSeries, yellowSeries, blueSeries, purpleSeries, greySeries, userDefined, COUNT };
    };

    static DbGraph *self();
    static DbGraph *create(QQmlEngine *, QJSEngine *);
    ~DbGraph() override;

    /**
      Set Graph color scheme
    */
    static
    void setColorScheme( int v )
    {
      if (v != self()->mColorScheme && !self()->isColorSchemeImmutable()) {
        self()->mColorScheme = v;
        Q_EMIT self()->colorSchemeChanged();
      }
    }

    Q_PROPERTY(int colorScheme READ colorScheme WRITE setColorScheme NOTIFY colorSchemeChanged)
    Q_PROPERTY(bool isColorSchemeImmutable READ isColorSchemeImmutable CONSTANT)
    Q_PROPERTY(int defaultColorSchemeValue READ defaultColorSchemeValue CONSTANT)
    /**
      Get Graph color scheme
    */
    static
    int colorScheme()
    {
      return self()->mColorScheme;
    }

    /**
      Is Graph color scheme Immutable
    */
    static
    bool isColorSchemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "colorScheme" ) );
    }

    /**
      Get Graph color scheme default value
    */
    static
    int defaultColorSchemeValue()
    {
        return defaultColorSchemeValue_helper();
    }

    /**
      Set Graph color theme
    */
    static
    void setColorTheme( int v )
    {
      if (v != self()->mColorTheme && !self()->isColorThemeImmutable()) {
        self()->mColorTheme = v;
        Q_EMIT self()->colorThemeChanged();
      }
    }

    Q_PROPERTY(int colorTheme READ colorTheme WRITE setColorTheme NOTIFY colorThemeChanged)
    Q_PROPERTY(bool isColorThemeImmutable READ isColorThemeImmutable CONSTANT)
    Q_PROPERTY(int defaultColorThemeValue READ defaultColorThemeValue CONSTANT)
    /**
      Get Graph color theme
    */
    static
    int colorTheme()
    {
      return self()->mColorTheme;
    }

    /**
      Is Graph color theme Immutable
    */
    static
    bool isColorThemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "colorTheme" ) );
    }

    /**
      Get Graph color theme default value
    */
    static
    int defaultColorThemeValue()
    {
        return defaultColorThemeValue_helper();
    }

    /**
      Set Plot area background color
    */
    static
    void setPlotAreaBackgroundColor( const QColor & v )
    {
      if (v != self()->mPlotAreaBackgroundColor && !self()->isPlotAreaBackgroundColorImmutable()) {
        self()->mPlotAreaBackgroundColor = v;
        Q_EMIT self()->plotAreaBackgroundColorChanged();
      }
    }

    Q_PROPERTY(QColor plotAreaBackgroundColor READ plotAreaBackgroundColor WRITE setPlotAreaBackgroundColor NOTIFY plotAreaBackgroundColorChanged)
    Q_PROPERTY(bool isPlotAreaBackgroundColorImmutable READ isPlotAreaBackgroundColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultPlotAreaBackgroundColorValue READ defaultPlotAreaBackgroundColorValue CONSTANT)
    /**
      Get Plot area background color
    */
    static
    QColor plotAreaBackgroundColor()
    {
      return self()->mPlotAreaBackgroundColor;
    }

    /**
      Is Plot area background color Immutable
    */
    static
    bool isPlotAreaBackgroundColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "plotAreaBackgroundColor" ) );
    }

    /**
      Get Plot area background color default value
    */
    static
    QColor defaultPlotAreaBackgroundColorValue()
    {
        return defaultPlotAreaBackgroundColorValue_helper();
    }

    /**
      Set Background color
    */
    static
    void setBackgroundColor( const QColor & v )
    {
      if (v != self()->mBackgroundColor && !self()->isBackgroundColorImmutable()) {
        self()->mBackgroundColor = v;
        Q_EMIT self()->backgroundColorChanged();
      }
    }

    Q_PROPERTY(QColor backgroundColor READ backgroundColor WRITE setBackgroundColor NOTIFY backgroundColorChanged)
    Q_PROPERTY(bool isBackgroundColorImmutable READ isBackgroundColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultBackgroundColorValue READ defaultBackgroundColorValue CONSTANT)
    /**
      Get Background color
    */
    static
    QColor backgroundColor()
    {
      return self()->mBackgroundColor;
    }

    /**
      Is Background color Immutable
    */
    static
    bool isBackgroundColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "backgroundColor" ) );
    }

    /**
      Get Background color default value
    */
    static
    QColor defaultBackgroundColorValue()
    {
        return defaultBackgroundColorValue_helper();
    }

    /**
      Set Data series color
    */
    static
    void setSeriesColors( const QColor & v )
    {
      if (v != self()->mSeriesColors && !self()->isSeriesColorsImmutable()) {
        self()->mSeriesColors = v;
        Q_EMIT self()->seriesColorsChanged();
      }
    }

    Q_PROPERTY(QColor seriesColors READ seriesColors WRITE setSeriesColors NOTIFY seriesColorsChanged)
    Q_PROPERTY(bool isSeriesColorsImmutable READ isSeriesColorsImmutable CONSTANT)
    Q_PROPERTY(QColor defaultSeriesColorsValue READ defaultSeriesColorsValue CONSTANT)
    /**
      Get Data series color
    */
    static
    QColor seriesColors()
    {
      return self()->mSeriesColors;
    }

    /**
      Is Data series color Immutable
    */
    static
    bool isSeriesColorsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "seriesColors" ) );
    }

    /**
      Get Data series color default value
    */
    static
    QColor defaultSeriesColorsValue()
    {
        return defaultSeriesColorsValue_helper();
    }

    /**
      Set Axis label color
    */
    static
    void setLabelTextColor( const QColor & v )
    {
      if (v != self()->mLabelTextColor && !self()->isLabelTextColorImmutable()) {
        self()->mLabelTextColor = v;
        Q_EMIT self()->labelTextColorChanged();
      }
    }

    Q_PROPERTY(QColor labelTextColor READ labelTextColor WRITE setLabelTextColor NOTIFY labelTextColorChanged)
    Q_PROPERTY(bool isLabelTextColorImmutable READ isLabelTextColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultLabelTextColorValue READ defaultLabelTextColorValue CONSTANT)
    /**
      Get Axis label color
    */
    static
    QColor labelTextColor()
    {
      return self()->mLabelTextColor;
    }

    /**
      Is Axis label color Immutable
    */
    static
    bool isLabelTextColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "labelTextColor" ) );
    }

    /**
      Get Axis label color default value
    */
    static
    QColor defaultLabelTextColorValue()
    {
        return defaultLabelTextColorValue_helper();
    }

    /**
      Set Axis label background color
    */
    static
    void setLabelBackgroundColor( const QColor & v )
    {
      if (v != self()->mLabelBackgroundColor && !self()->isLabelBackgroundColorImmutable()) {
        self()->mLabelBackgroundColor = v;
        Q_EMIT self()->labelBackgroundColorChanged();
      }
    }

    Q_PROPERTY(QColor labelBackgroundColor READ labelBackgroundColor WRITE setLabelBackgroundColor NOTIFY labelBackgroundColorChanged)
    Q_PROPERTY(bool isLabelBackgroundColorImmutable READ isLabelBackgroundColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultLabelBackgroundColorValue READ defaultLabelBackgroundColorValue CONSTANT)
    /**
      Get Axis label background color
    */
    static
    QColor labelBackgroundColor()
    {
      return self()->mLabelBackgroundColor;
    }

    /**
      Is Axis label background color Immutable
    */
    static
    bool isLabelBackgroundColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "labelBackgroundColor" ) );
    }

    /**
      Get Axis label background color default value
    */
    static
    QColor defaultLabelBackgroundColorValue()
    {
        return defaultLabelBackgroundColorValue_helper();
    }

    /**
      Set Border color
    */
    static
    void setBorderColors( const QColor & v )
    {
      if (v != self()->mBorderColors && !self()->isBorderColorsImmutable()) {
        self()->mBorderColors = v;
        Q_EMIT self()->borderColorsChanged();
      }
    }

    Q_PROPERTY(QColor borderColors READ borderColors WRITE setBorderColors NOTIFY borderColorsChanged)
    Q_PROPERTY(bool isBorderColorsImmutable READ isBorderColorsImmutable CONSTANT)
    Q_PROPERTY(QColor defaultBorderColorsValue READ defaultBorderColorsValue CONSTANT)
    /**
      Get Border color
    */
    static
    QColor borderColors()
    {
      return self()->mBorderColors;
    }

    /**
      Is Border color Immutable
    */
    static
    bool isBorderColorsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "borderColors" ) );
    }

    /**
      Get Border color default value
    */
    static
    QColor defaultBorderColorsValue()
    {
        return defaultBorderColorsValue_helper();
    }

    /**
      Set Line and spline series line width
    */
    static
    void setLineWidth( double v )
    {
      if (v < 0)
      {
        qDebug() << "setLineWidth: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 50)
      {
        qDebug() << "setLineWidth: value " << v << " is greater than the maximum value of 50";
        v = 50;
      }

      if (v != self()->mLineWidth && !self()->isLineWidthImmutable()) {
        self()->mLineWidth = v;
        Q_EMIT self()->lineWidthChanged();
      }
    }

    Q_PROPERTY(double lineWidth READ lineWidth WRITE setLineWidth NOTIFY lineWidthChanged)
    Q_PROPERTY(bool isLineWidthImmutable READ isLineWidthImmutable CONSTANT)
    Q_PROPERTY(double defaultLineWidthValue READ defaultLineWidthValue CONSTANT)
    /**
      Get Line and spline series line width
    */
    static
    double lineWidth()
    {
      return self()->mLineWidth;
    }

    /**
      Is Line and spline series line width Immutable
    */
    static
    bool isLineWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lineWidth" ) );
    }

    /**
      Get Line and spline series line width default value
    */
    static
    double defaultLineWidthValue()
    {
        return defaultLineWidthValue_helper();
    }

    /**
      Set gridVisible
    */
    static
    void setGridVisible( bool v )
    {
      if (v != self()->mGridVisible && !self()->isGridVisibleImmutable()) {
        self()->mGridVisible = v;
        Q_EMIT self()->gridVisibleChanged();
      }
    }

    Q_PROPERTY(bool gridVisible READ gridVisible WRITE setGridVisible NOTIFY gridVisibleChanged)
    Q_PROPERTY(bool isGridVisibleImmutable READ isGridVisibleImmutable CONSTANT)
    Q_PROPERTY(bool defaultGridVisibleValue READ defaultGridVisibleValue CONSTANT)
    /**
      Get gridVisible
    */
    static
    bool gridVisible()
    {
      return self()->mGridVisible;
    }

    /**
      Is gridVisible Immutable
    */
    static
    bool isGridVisibleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "gridVisible" ) );
    }

    /**
      Get gridVisible default value
    */
    static
    bool defaultGridVisibleValue()
    {
        return defaultGridVisibleValue_helper();
    }


    enum {
      signalColorSchemeChanged = 1,
      signalColorThemeChanged = 2,
      signalPlotAreaBackgroundColorChanged = 3,
      signalBackgroundColorChanged = 4,
      signalSeriesColorsChanged = 5,
      signalLabelTextColorChanged = 6,
      signalLabelBackgroundColorChanged = 7,
      signalBorderColorsChanged = 8,
      signalLineWidthChanged = 9,
      signalGridVisibleChanged = 10
    };

  Q_SIGNALS:
    void colorSchemeChanged();

    void colorThemeChanged();

    void plotAreaBackgroundColorChanged();

    void backgroundColorChanged();

    void seriesColorsChanged();

    void labelTextColorChanged();

    void labelBackgroundColorChanged();

    void borderColorsChanged();

    void lineWidthChanged();

    void gridVisibleChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    DbGraph();
    friend class DbGraphHelper;


    // Graph
    int mColorScheme;
    static int defaultColorSchemeValue_helper();
    int mColorTheme;
    static int defaultColorThemeValue_helper();
    QColor mPlotAreaBackgroundColor;
    static QColor defaultPlotAreaBackgroundColorValue_helper();
    QColor mBackgroundColor;
    static QColor defaultBackgroundColorValue_helper();
    QColor mSeriesColors;
    static QColor defaultSeriesColorsValue_helper();
    QColor mLabelTextColor;
    static QColor defaultLabelTextColorValue_helper();
    QColor mLabelBackgroundColor;
    static QColor defaultLabelBackgroundColorValue_helper();
    QColor mBorderColors;
    static QColor defaultBorderColorsValue_helper();
    double mLineWidth;
    static double defaultLineWidthValue_helper();
    bool mGridVisible;
    static bool defaultGridVisibleValue_helper();
};

#endif

