// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v5.29.3
// source: envoy/extensions/filters/http/ratelimit/v3/rate_limit.proto

package ratelimitv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v32 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/ratelimit/v3"
	v33 "github.com/envoyproxy/go-control-plane/envoy/config/route/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/type/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the version of the standard to use for X-RateLimit headers.
//
// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.XRateLimitHeadersRFCVersion instead.]
type RateLimit_XRateLimitHeadersRFCVersion int32

const (
	// X-RateLimit headers disabled.
	RateLimit_OFF RateLimit_XRateLimitHeadersRFCVersion = 0
	// Use `draft RFC Version 03 <https://tools.ietf.org/id/draft-polli-ratelimit-headers-03.html>`_.
	RateLimit_DRAFT_VERSION_03 RateLimit_XRateLimitHeadersRFCVersion = 1
)

// Enum value maps for RateLimit_XRateLimitHeadersRFCVersion.
var (
	RateLimit_XRateLimitHeadersRFCVersion_name = map[int32]string{
		0: "OFF",
		1: "DRAFT_VERSION_03",
	}
	RateLimit_XRateLimitHeadersRFCVersion_value = map[string]int32{
		"OFF":              0,
		"DRAFT_VERSION_03": 1,
	}
)

func (x RateLimit_XRateLimitHeadersRFCVersion) Enum() *RateLimit_XRateLimitHeadersRFCVersion {
	p := new(RateLimit_XRateLimitHeadersRFCVersion)
	*p = x
	return p
}

func (x RateLimit_XRateLimitHeadersRFCVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimit_XRateLimitHeadersRFCVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[0].Descriptor()
}

func (RateLimit_XRateLimitHeadersRFCVersion) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[0]
}

func (x RateLimit_XRateLimitHeadersRFCVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimit_XRateLimitHeadersRFCVersion.Descriptor instead.
func (RateLimit_XRateLimitHeadersRFCVersion) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{0, 0}
}

// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.VhRateLimitsOptions instead.]
type RateLimitPerRoute_VhRateLimitsOptions int32

const (
	// Use the virtual host rate limits unless the route has a rate limit policy.
	RateLimitPerRoute_OVERRIDE RateLimitPerRoute_VhRateLimitsOptions = 0
	// Use the virtual host rate limits even if the route has a rate limit policy.
	RateLimitPerRoute_INCLUDE RateLimitPerRoute_VhRateLimitsOptions = 1
	// Ignore the virtual host rate limits even if the route does not have a rate limit policy.
	RateLimitPerRoute_IGNORE RateLimitPerRoute_VhRateLimitsOptions = 2
)

// Enum value maps for RateLimitPerRoute_VhRateLimitsOptions.
var (
	RateLimitPerRoute_VhRateLimitsOptions_name = map[int32]string{
		0: "OVERRIDE",
		1: "INCLUDE",
		2: "IGNORE",
	}
	RateLimitPerRoute_VhRateLimitsOptions_value = map[string]int32{
		"OVERRIDE": 0,
		"INCLUDE":  1,
		"IGNORE":   2,
	}
)

func (x RateLimitPerRoute_VhRateLimitsOptions) Enum() *RateLimitPerRoute_VhRateLimitsOptions {
	p := new(RateLimitPerRoute_VhRateLimitsOptions)
	*p = x
	return p
}

func (x RateLimitPerRoute_VhRateLimitsOptions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimitPerRoute_VhRateLimitsOptions) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[1].Descriptor()
}

func (RateLimitPerRoute_VhRateLimitsOptions) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[1]
}

func (x RateLimitPerRoute_VhRateLimitsOptions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimitPerRoute_VhRateLimitsOptions.Descriptor instead.
func (RateLimitPerRoute_VhRateLimitsOptions) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 0}
}

// The override option determines how the filter handles the cases where there is an override config at a more specific level than this one (from least to most specific: virtual host, route, cluster weight).
// [#not-implemented-hide:]
type RateLimitPerRoute_OverrideOptions int32

const (
	// Client-defined default, typically OVERRIDE_POLICY. If VhRateLimitsOptions is set, that will be used instead.
	RateLimitPerRoute_DEFAULT RateLimitPerRoute_OverrideOptions = 0
	// If there is an override config at a more specific level, use that instead of this one.
	RateLimitPerRoute_OVERRIDE_POLICY RateLimitPerRoute_OverrideOptions = 1
	// If there is an override config at a more specific level, use data from both.
	RateLimitPerRoute_INCLUDE_POLICY RateLimitPerRoute_OverrideOptions = 2
	// If there is an override config at a more specific level, ignore it and use only this one.
	RateLimitPerRoute_IGNORE_POLICY RateLimitPerRoute_OverrideOptions = 3
)

// Enum value maps for RateLimitPerRoute_OverrideOptions.
var (
	RateLimitPerRoute_OverrideOptions_name = map[int32]string{
		0: "DEFAULT",
		1: "OVERRIDE_POLICY",
		2: "INCLUDE_POLICY",
		3: "IGNORE_POLICY",
	}
	RateLimitPerRoute_OverrideOptions_value = map[string]int32{
		"DEFAULT":         0,
		"OVERRIDE_POLICY": 1,
		"INCLUDE_POLICY":  2,
		"IGNORE_POLICY":   3,
	}
)

func (x RateLimitPerRoute_OverrideOptions) Enum() *RateLimitPerRoute_OverrideOptions {
	p := new(RateLimitPerRoute_OverrideOptions)
	*p = x
	return p
}

func (x RateLimitPerRoute_OverrideOptions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RateLimitPerRoute_OverrideOptions) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[2].Descriptor()
}

func (RateLimitPerRoute_OverrideOptions) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes[2]
}

func (x RateLimitPerRoute_OverrideOptions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RateLimitPerRoute_OverrideOptions.Descriptor instead.
func (RateLimitPerRoute_OverrideOptions) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1, 1}
}

// [#next-free-field: 18]
type RateLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rate limit domain to use when calling the rate limit service.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// Specifies the rate limit configurations to be applied with the same
	// stage number. If not set, the default stage number is 0.
	//
	// .. note::
	//
	//	The filter supports a range of 0 - 10 inclusively for stage numbers.
	Stage uint32 `protobuf:"varint,2,opt,name=stage,proto3" json:"stage,omitempty"`
	// The type of requests the filter should apply to. The supported
	// types are “internal“, “external“ or “both“. A request is considered internal if
	// :ref:`x-envoy-internal<config_http_conn_man_headers_x-envoy-internal>` is set to true. If
	// :ref:`x-envoy-internal<config_http_conn_man_headers_x-envoy-internal>` is not set or false, a
	// request is considered external. The filter defaults to “both“, and it will apply to all request
	// types.
	RequestType string `protobuf:"bytes,3,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The timeout in milliseconds for the rate limit service RPC. If not
	// set, this defaults to 20ms.
	Timeout *durationpb.Duration `protobuf:"bytes,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The filter's behaviour in case the rate limiting service does
	// not respond back. When it is set to true, Envoy will not allow traffic in case of
	// communication failure between rate limiting service and the proxy.
	FailureModeDeny bool `protobuf:"varint,5,opt,name=failure_mode_deny,json=failureModeDeny,proto3" json:"failure_mode_deny,omitempty"`
	// Specifies whether a “RESOURCE_EXHAUSTED“ gRPC code must be returned instead
	// of the default “UNAVAILABLE“ gRPC code for a rate limited gRPC call. The
	// HTTP code will be 200 for a gRPC response.
	RateLimitedAsResourceExhausted bool `protobuf:"varint,6,opt,name=rate_limited_as_resource_exhausted,json=rateLimitedAsResourceExhausted,proto3" json:"rate_limited_as_resource_exhausted,omitempty"`
	// Configuration for an external rate limit service provider. If not
	// specified, any calls to the rate limit service will immediately return
	// success.
	RateLimitService *v3.RateLimitServiceConfig `protobuf:"bytes,7,opt,name=rate_limit_service,json=rateLimitService,proto3" json:"rate_limit_service,omitempty"`
	// Defines the standard version to use for X-RateLimit headers emitted by the filter:
	//
	//   - “X-RateLimit-Limit“ - indicates the request-quota associated to the
	//     client in the current time-window followed by the description of the
	//     quota policy. The values are returned by the rate limiting service in
	//     :ref:`current_limit<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.DescriptorStatus.current_limit>`
	//     field. Example: “10, 10;w=1;name="per-ip", 1000;w=3600“.
	//   - “X-RateLimit-Remaining“ - indicates the remaining requests in the
	//     current time-window. The values are returned by the rate limiting service
	//     in :ref:`limit_remaining<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.DescriptorStatus.limit_remaining>`
	//     field.
	//   - “X-RateLimit-Reset“ - indicates the number of seconds until reset of
	//     the current time-window. The values are returned by the rate limiting service
	//     in :ref:`duration_until_reset<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.DescriptorStatus.duration_until_reset>`
	//     field.
	//
	// In case rate limiting policy specifies more than one time window, the values
	// above represent the window that is closest to reaching its limit.
	//
	// For more information about the headers specification see selected version of
	// the `draft RFC <https://tools.ietf.org/id/draft-polli-ratelimit-headers-03.html>`_.
	//
	// Disabled by default.
	//
	// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.XRateLimitHeadersRFCVersion instead.]
	EnableXRatelimitHeaders RateLimit_XRateLimitHeadersRFCVersion `protobuf:"varint,8,opt,name=enable_x_ratelimit_headers,json=enableXRatelimitHeaders,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimit_XRateLimitHeadersRFCVersion" json:"enable_x_ratelimit_headers,omitempty"`
	// Disables emitting the :ref:`x-envoy-ratelimited<config_http_filters_router_x-envoy-ratelimited>` header
	// in case of rate limiting (i.e. 429 responses).
	// Having this header not present potentially makes the request retriable.
	DisableXEnvoyRatelimitedHeader bool `protobuf:"varint,9,opt,name=disable_x_envoy_ratelimited_header,json=disableXEnvoyRatelimitedHeader,proto3" json:"disable_x_envoy_ratelimited_header,omitempty"`
	// This field allows for a custom HTTP response status code to the downstream client when
	// the request has been rate limited.
	// Defaults to 429 (TooManyRequests).
	//
	// .. note::
	//
	//	If this is set to < 400, 429 will be used instead.
	RateLimitedStatus *v31.HttpStatus `protobuf:"bytes,10,opt,name=rate_limited_status,json=rateLimitedStatus,proto3" json:"rate_limited_status,omitempty"`
	// Specifies a list of HTTP headers that should be added to each response for requests that
	// have been rate limited.
	ResponseHeadersToAdd []*v32.HeaderValueOption `protobuf:"bytes,11,rep,name=response_headers_to_add,json=responseHeadersToAdd,proto3" json:"response_headers_to_add,omitempty"`
	// Sets the HTTP status that is returned to the client when the ratelimit server returns an error
	// or cannot be reached. The default status is 500.
	StatusOnError *v31.HttpStatus `protobuf:"bytes,12,opt,name=status_on_error,json=statusOnError,proto3" json:"status_on_error,omitempty"`
	// Optional additional prefix to use when emitting statistics. This allows to distinguish
	// emitted statistics between configured “ratelimit“ filters in an HTTP filter chain.
	StatPrefix string `protobuf:"bytes,13,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// If set, this will enable -- but not necessarily enforce -- the rate limit for the given
	// fraction of requests.
	//
	// If not set then “ratelimit.http_filter_enabled“ runtime key will be used to determine
	// the fraction of requests to enforce rate limits on. And the default percentage of the
	// runtime key is 100% for backwards compatibility.
	FilterEnabled *v32.RuntimeFractionalPercent `protobuf:"bytes,14,opt,name=filter_enabled,json=filterEnabled,proto3" json:"filter_enabled,omitempty"`
	// If set, this will enforce the rate limit decisions for the given fraction of requests.
	//
	// Note: this only applies to the fraction of enabled requests.
	//
	// If not set then “ratelimit.http_filter_enforcing“ runtime key will be used to determine
	// the fraction of requests to enforce rate limits on. And the default percentage of the
	// runtime key is 100% for backwards compatibility.
	FilterEnforced *v32.RuntimeFractionalPercent `protobuf:"bytes,15,opt,name=filter_enforced,json=filterEnforced,proto3" json:"filter_enforced,omitempty"`
	// If set, this will override the failure_mode_deny parameter with a runtime fraction.
	// If the runtime key is not specified, the value of failure_mode_deny will be used.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//	failure_mode_deny: true
	//	failure_mode_deny_percent:
	//	  default_value:
	//	    numerator: 50
	//	    denominator: HUNDRED
	//	  runtime_key: ratelimit.failure_mode_deny_percent
	//
	// This means that when the rate limit service is unavailable, 50% of requests will be denied
	// (fail closed) and 50% will be allowed (fail open).
	FailureModeDenyPercent *v32.RuntimeFractionalPercent `protobuf:"bytes,16,opt,name=failure_mode_deny_percent,json=failureModeDenyPercent,proto3" json:"failure_mode_deny_percent,omitempty"`
	// Rate limit configuration that is used to generate a list of descriptor entries based on
	// the request context. The generated entries will be sent to the rate limit service.
	// If this is set, then
	// :ref:`VirtualHost.rate_limits<envoy_v3_api_field_config.route.v3.VirtualHost.rate_limits>` or
	// :ref:`RouteAction.rate_limits<envoy_v3_api_field_config.route.v3.RouteAction.rate_limits>` fields
	// will be ignored. However, :ref:`RateLimitPerRoute.rate_limits<envoy_v3_api_field_extensions.filters.http.ratelimit.v3.RateLimitPerRoute.rate_limits>`
	// will take precedence over this field.
	//
	// .. note::
	//
	//	Not all configuration fields of
	//	:ref:`rate limit config <envoy_v3_api_msg_config.route.v3.RateLimit>` is supported at here.
	//	Following fields are not supported:
	//
	//	1. :ref:`rate limit stage <envoy_v3_api_field_config.route.v3.RateLimit.stage>`.
	//	2. :ref:`dynamic metadata <envoy_v3_api_field_config.route.v3.RateLimit.Action.dynamic_metadata>`.
	//	3. :ref:`disable_key <envoy_v3_api_field_config.route.v3.RateLimit.disable_key>`.
	//	4. :ref:`override limit <envoy_v3_api_field_config.route.v3.RateLimit.limit>`.
	//	5. :ref:`hits_addend <envoy_v3_api_field_config.route.v3.RateLimit.hits_addend>`.
	//	6. :ref:`apply_on_stream_done <envoy_v3_api_field_config.route.v3.RateLimit.apply_on_stream_done>`.
	RateLimits []*v33.RateLimit `protobuf:"bytes,17,rep,name=rate_limits,json=rateLimits,proto3" json:"rate_limits,omitempty"`
}

func (x *RateLimit) Reset() {
	*x = RateLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimit) ProtoMessage() {}

func (x *RateLimit) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimit.ProtoReflect.Descriptor instead.
func (*RateLimit) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{0}
}

func (x *RateLimit) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *RateLimit) GetStage() uint32 {
	if x != nil {
		return x.Stage
	}
	return 0
}

func (x *RateLimit) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *RateLimit) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *RateLimit) GetFailureModeDeny() bool {
	if x != nil {
		return x.FailureModeDeny
	}
	return false
}

func (x *RateLimit) GetRateLimitedAsResourceExhausted() bool {
	if x != nil {
		return x.RateLimitedAsResourceExhausted
	}
	return false
}

func (x *RateLimit) GetRateLimitService() *v3.RateLimitServiceConfig {
	if x != nil {
		return x.RateLimitService
	}
	return nil
}

func (x *RateLimit) GetEnableXRatelimitHeaders() RateLimit_XRateLimitHeadersRFCVersion {
	if x != nil {
		return x.EnableXRatelimitHeaders
	}
	return RateLimit_OFF
}

func (x *RateLimit) GetDisableXEnvoyRatelimitedHeader() bool {
	if x != nil {
		return x.DisableXEnvoyRatelimitedHeader
	}
	return false
}

func (x *RateLimit) GetRateLimitedStatus() *v31.HttpStatus {
	if x != nil {
		return x.RateLimitedStatus
	}
	return nil
}

func (x *RateLimit) GetResponseHeadersToAdd() []*v32.HeaderValueOption {
	if x != nil {
		return x.ResponseHeadersToAdd
	}
	return nil
}

func (x *RateLimit) GetStatusOnError() *v31.HttpStatus {
	if x != nil {
		return x.StatusOnError
	}
	return nil
}

func (x *RateLimit) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *RateLimit) GetFilterEnabled() *v32.RuntimeFractionalPercent {
	if x != nil {
		return x.FilterEnabled
	}
	return nil
}

func (x *RateLimit) GetFilterEnforced() *v32.RuntimeFractionalPercent {
	if x != nil {
		return x.FilterEnforced
	}
	return nil
}

func (x *RateLimit) GetFailureModeDenyPercent() *v32.RuntimeFractionalPercent {
	if x != nil {
		return x.FailureModeDenyPercent
	}
	return nil
}

func (x *RateLimit) GetRateLimits() []*v33.RateLimit {
	if x != nil {
		return x.RateLimits
	}
	return nil
}

type RateLimitPerRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies if the rate limit filter should include the virtual host rate limits.
	// [#next-major-version: unify with local ratelimit, should use common.ratelimit.v3.VhRateLimitsOptions instead.]
	VhRateLimits RateLimitPerRoute_VhRateLimitsOptions `protobuf:"varint,1,opt,name=vh_rate_limits,json=vhRateLimits,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute_VhRateLimitsOptions" json:"vh_rate_limits,omitempty"`
	// Specifies if the rate limit filter should include the lower levels (route level, virtual host level or cluster weight level) rate limits override options.
	// [#not-implemented-hide:]
	OverrideOption RateLimitPerRoute_OverrideOptions `protobuf:"varint,2,opt,name=override_option,json=overrideOption,proto3,enum=envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute_OverrideOptions" json:"override_option,omitempty"`
	// Rate limit configuration that is used to generate a list of descriptor entries based on
	// the request context. The generated entries will be used to find one or multiple matched rate
	// limit rule from the “descriptors“.
	// If this is set, then
	// :ref:`VirtualHost.rate_limits<envoy_v3_api_field_config.route.v3.VirtualHost.rate_limits>`,
	// :ref:`RouteAction.rate_limits<envoy_v3_api_field_config.route.v3.RouteAction.rate_limits>` and
	// :ref:`RateLimit.rate_limits<envoy_v3_api_field_extensions.filters.http.ratelimit.v3.RateLimit.rate_limits>` fields
	// will be ignored.
	//
	// .. note::
	//
	//	Not all configuration fields of
	//	:ref:`rate limit config <envoy_v3_api_msg_config.route.v3.RateLimit>` is supported at here.
	//	Following fields are not supported:
	//
	//	1. :ref:`rate limit stage <envoy_v3_api_field_config.route.v3.RateLimit.stage>`.
	//	2. :ref:`dynamic metadata <envoy_v3_api_field_config.route.v3.RateLimit.Action.dynamic_metadata>`.
	//	3. :ref:`disable_key <envoy_v3_api_field_config.route.v3.RateLimit.disable_key>`.
	//	4. :ref:`override limit <envoy_v3_api_field_config.route.v3.RateLimit.limit>`.
	RateLimits []*v33.RateLimit `protobuf:"bytes,3,rep,name=rate_limits,json=rateLimits,proto3" json:"rate_limits,omitempty"`
	// Overrides the domain. If not set, uses the filter-level domain instead.
	Domain string `protobuf:"bytes,4,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *RateLimitPerRoute) Reset() {
	*x = RateLimitPerRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitPerRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitPerRoute) ProtoMessage() {}

func (x *RateLimitPerRoute) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitPerRoute.ProtoReflect.Descriptor instead.
func (*RateLimitPerRoute) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP(), []int{1}
}

func (x *RateLimitPerRoute) GetVhRateLimits() RateLimitPerRoute_VhRateLimitsOptions {
	if x != nil {
		return x.VhRateLimits
	}
	return RateLimitPerRoute_OVERRIDE
}

func (x *RateLimitPerRoute) GetOverrideOption() RateLimitPerRoute_OverrideOptions {
	if x != nil {
		return x.OverrideOption
	}
	return RateLimitPerRoute_DEFAULT
}

func (x *RateLimitPerRoute) GetRateLimits() []*v33.RateLimit {
	if x != nil {
		return x.RateLimits
	}
	return nil
}

func (x *RateLimitPerRoute) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

var File_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74,
	0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x68, 0x74, 0x74,
	0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d,
	0x75, 0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x75,
	0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfe, 0x0a, 0x0a, 0x09, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1f, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01,
	0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x18, 0x0a,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x44, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa,
	0x42, 0x1e, 0x72, 0x1c, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x08,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x04, 0x62, 0x6f, 0x74, 0x68, 0x52, 0x00,
	0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x33, 0x0a,
	0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x5f, 0x64, 0x65, 0x6e, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x6e, 0x79, 0x12, 0x4a,
	0x0a, 0x22, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x68, 0x61, 0x75,
	0x73, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1e, 0x72, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x41, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x45, 0x78, 0x68, 0x61, 0x75, 0x73, 0x74, 0x65, 0x64, 0x12, 0x69, 0x0a, 0x12, 0x72, 0x61,
	0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x10, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x98, 0x01, 0x0a, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x78, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x2e, 0x58, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x52, 0x46, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x58,
	0x52, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x12, 0x4a, 0x0a, 0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x78, 0x5f, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1e, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x58, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x52, 0x61, 0x74, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x13,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x11, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x65,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x68, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x61,
	0x64, 0x64, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a, 0x52, 0x14, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x41, 0x64,
	0x64, 0x12, 0x41, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4f, 0x6e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x55, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x0f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x64, 0x12, 0x69, 0x0a, 0x19, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x52, 0x16, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x6e, 0x79, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x12, 0x41, 0x0a, 0x0b, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18,
	0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x0a, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x22, 0x3c, 0x0a, 0x1b, 0x58, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x46, 0x43, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x44,
	0x52, 0x41, 0x46, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x30, 0x33, 0x10,
	0x01, 0x3a, 0x37, 0x9a, 0xc5, 0x88, 0x1e, 0x32, 0x0a, 0x30, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0x8f, 0x04, 0x0a, 0x11, 0x52,
	0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x12, 0x81, 0x01, 0x0a, 0x0e, 0x76, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x50, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x56, 0x68, 0x52, 0x61, 0x74, 0x65, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x76, 0x68, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72,
	0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x0b, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x0a,
	0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x22, 0x3c, 0x0a, 0x13, 0x56, 0x68, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x56, 0x45,
	0x52, 0x52, 0x49, 0x44, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x43, 0x4c, 0x55,
	0x44, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x10, 0x02,
	0x22, 0x5a, 0x0a, 0x0f, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00,
	0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x56, 0x45, 0x52, 0x52, 0x49, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x49, 0x47, 0x4e,
	0x4f, 0x52, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x03, 0x42, 0xb3, 0x01, 0xba,
	0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x02, 0x0a, 0x38, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x76,
	0x33, 0x42, 0x0e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2d, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x2f, 0x76, 0x33, 0x3b, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x76, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData = file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc
)

func file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData)
	})
	return file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDescData
}

var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_goTypes = []interface{}{
	(RateLimit_XRateLimitHeadersRFCVersion)(0), // 0: envoy.extensions.filters.http.ratelimit.v3.RateLimit.XRateLimitHeadersRFCVersion
	(RateLimitPerRoute_VhRateLimitsOptions)(0), // 1: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.VhRateLimitsOptions
	(RateLimitPerRoute_OverrideOptions)(0),     // 2: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.OverrideOptions
	(*RateLimit)(nil),                          // 3: envoy.extensions.filters.http.ratelimit.v3.RateLimit
	(*RateLimitPerRoute)(nil),                  // 4: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute
	(*durationpb.Duration)(nil),                // 5: google.protobuf.Duration
	(*v3.RateLimitServiceConfig)(nil),          // 6: envoy.config.ratelimit.v3.RateLimitServiceConfig
	(*v31.HttpStatus)(nil),                     // 7: envoy.type.v3.HttpStatus
	(*v32.HeaderValueOption)(nil),              // 8: envoy.config.core.v3.HeaderValueOption
	(*v32.RuntimeFractionalPercent)(nil),       // 9: envoy.config.core.v3.RuntimeFractionalPercent
	(*v33.RateLimit)(nil),                      // 10: envoy.config.route.v3.RateLimit
}
var file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_depIdxs = []int32{
	5,  // 0: envoy.extensions.filters.http.ratelimit.v3.RateLimit.timeout:type_name -> google.protobuf.Duration
	6,  // 1: envoy.extensions.filters.http.ratelimit.v3.RateLimit.rate_limit_service:type_name -> envoy.config.ratelimit.v3.RateLimitServiceConfig
	0,  // 2: envoy.extensions.filters.http.ratelimit.v3.RateLimit.enable_x_ratelimit_headers:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimit.XRateLimitHeadersRFCVersion
	7,  // 3: envoy.extensions.filters.http.ratelimit.v3.RateLimit.rate_limited_status:type_name -> envoy.type.v3.HttpStatus
	8,  // 4: envoy.extensions.filters.http.ratelimit.v3.RateLimit.response_headers_to_add:type_name -> envoy.config.core.v3.HeaderValueOption
	7,  // 5: envoy.extensions.filters.http.ratelimit.v3.RateLimit.status_on_error:type_name -> envoy.type.v3.HttpStatus
	9,  // 6: envoy.extensions.filters.http.ratelimit.v3.RateLimit.filter_enabled:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	9,  // 7: envoy.extensions.filters.http.ratelimit.v3.RateLimit.filter_enforced:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	9,  // 8: envoy.extensions.filters.http.ratelimit.v3.RateLimit.failure_mode_deny_percent:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	10, // 9: envoy.extensions.filters.http.ratelimit.v3.RateLimit.rate_limits:type_name -> envoy.config.route.v3.RateLimit
	1,  // 10: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.vh_rate_limits:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.VhRateLimitsOptions
	2,  // 11: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.override_option:type_name -> envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.OverrideOptions
	10, // 12: envoy.extensions.filters.http.ratelimit.v3.RateLimitPerRoute.rate_limits:type_name -> envoy.config.route.v3.RateLimit
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_init() }
func file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_init() {
	if File_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitPerRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto = out.File
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_rawDesc = nil
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_goTypes = nil
	file_envoy_extensions_filters_http_ratelimit_v3_rate_limit_proto_depIdxs = nil
}
