// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Service exported by server reflection.  A more complete description of how
// server reflection works can be found at
// https://github.com/grpc/grpc/blob/master/doc/server-reflection.md
//
// The canonical version of this proto can be found at
// https://github.com/grpc/grpc-proto/blob/master/grpc/reflection/v1/reflection.proto

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: grpc/reflection/v1/reflection.proto

package reflectionv1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The message sent by the client when calling ServerReflectionInfo method.
type ServerReflectionRequest struct {
	state                     protoimpl.MessageState                   `protogen:"opaque.v1"`
	xxx_hidden_Host           string                                   `protobuf:"bytes,1,opt,name=host,proto3"`
	xxx_hidden_MessageRequest isServerReflectionRequest_MessageRequest `protobuf_oneof:"message_request"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ServerReflectionRequest) Reset() {
	*x = ServerReflectionRequest{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerReflectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerReflectionRequest) ProtoMessage() {}

func (x *ServerReflectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ServerReflectionRequest) GetHost() string {
	if x != nil {
		return x.xxx_hidden_Host
	}
	return ""
}

func (x *ServerReflectionRequest) GetFileByFilename() string {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileByFilename); ok {
			return x.FileByFilename
		}
	}
	return ""
}

func (x *ServerReflectionRequest) GetFileContainingSymbol() string {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileContainingSymbol); ok {
			return x.FileContainingSymbol
		}
	}
	return ""
}

func (x *ServerReflectionRequest) GetFileContainingExtension() *ExtensionRequest {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileContainingExtension); ok {
			return x.FileContainingExtension
		}
	}
	return nil
}

func (x *ServerReflectionRequest) GetAllExtensionNumbersOfType() string {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_AllExtensionNumbersOfType); ok {
			return x.AllExtensionNumbersOfType
		}
	}
	return ""
}

func (x *ServerReflectionRequest) GetListServices() string {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_ListServices); ok {
			return x.ListServices
		}
	}
	return ""
}

func (x *ServerReflectionRequest) SetHost(v string) {
	x.xxx_hidden_Host = v
}

func (x *ServerReflectionRequest) SetFileByFilename(v string) {
	x.xxx_hidden_MessageRequest = &serverReflectionRequest_FileByFilename{v}
}

func (x *ServerReflectionRequest) SetFileContainingSymbol(v string) {
	x.xxx_hidden_MessageRequest = &serverReflectionRequest_FileContainingSymbol{v}
}

func (x *ServerReflectionRequest) SetFileContainingExtension(v *ExtensionRequest) {
	if v == nil {
		x.xxx_hidden_MessageRequest = nil
		return
	}
	x.xxx_hidden_MessageRequest = &serverReflectionRequest_FileContainingExtension{v}
}

func (x *ServerReflectionRequest) SetAllExtensionNumbersOfType(v string) {
	x.xxx_hidden_MessageRequest = &serverReflectionRequest_AllExtensionNumbersOfType{v}
}

func (x *ServerReflectionRequest) SetListServices(v string) {
	x.xxx_hidden_MessageRequest = &serverReflectionRequest_ListServices{v}
}

func (x *ServerReflectionRequest) HasMessageRequest() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_MessageRequest != nil
}

func (x *ServerReflectionRequest) HasFileByFilename() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileByFilename)
	return ok
}

func (x *ServerReflectionRequest) HasFileContainingSymbol() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileContainingSymbol)
	return ok
}

func (x *ServerReflectionRequest) HasFileContainingExtension() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileContainingExtension)
	return ok
}

func (x *ServerReflectionRequest) HasAllExtensionNumbersOfType() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_AllExtensionNumbersOfType)
	return ok
}

func (x *ServerReflectionRequest) HasListServices() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_ListServices)
	return ok
}

func (x *ServerReflectionRequest) ClearMessageRequest() {
	x.xxx_hidden_MessageRequest = nil
}

func (x *ServerReflectionRequest) ClearFileByFilename() {
	if _, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileByFilename); ok {
		x.xxx_hidden_MessageRequest = nil
	}
}

func (x *ServerReflectionRequest) ClearFileContainingSymbol() {
	if _, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileContainingSymbol); ok {
		x.xxx_hidden_MessageRequest = nil
	}
}

func (x *ServerReflectionRequest) ClearFileContainingExtension() {
	if _, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_FileContainingExtension); ok {
		x.xxx_hidden_MessageRequest = nil
	}
}

func (x *ServerReflectionRequest) ClearAllExtensionNumbersOfType() {
	if _, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_AllExtensionNumbersOfType); ok {
		x.xxx_hidden_MessageRequest = nil
	}
}

func (x *ServerReflectionRequest) ClearListServices() {
	if _, ok := x.xxx_hidden_MessageRequest.(*serverReflectionRequest_ListServices); ok {
		x.xxx_hidden_MessageRequest = nil
	}
}

const ServerReflectionRequest_MessageRequest_not_set_case case_ServerReflectionRequest_MessageRequest = 0
const ServerReflectionRequest_FileByFilename_case case_ServerReflectionRequest_MessageRequest = 3
const ServerReflectionRequest_FileContainingSymbol_case case_ServerReflectionRequest_MessageRequest = 4
const ServerReflectionRequest_FileContainingExtension_case case_ServerReflectionRequest_MessageRequest = 5
const ServerReflectionRequest_AllExtensionNumbersOfType_case case_ServerReflectionRequest_MessageRequest = 6
const ServerReflectionRequest_ListServices_case case_ServerReflectionRequest_MessageRequest = 7

func (x *ServerReflectionRequest) WhichMessageRequest() case_ServerReflectionRequest_MessageRequest {
	if x == nil {
		return ServerReflectionRequest_MessageRequest_not_set_case
	}
	switch x.xxx_hidden_MessageRequest.(type) {
	case *serverReflectionRequest_FileByFilename:
		return ServerReflectionRequest_FileByFilename_case
	case *serverReflectionRequest_FileContainingSymbol:
		return ServerReflectionRequest_FileContainingSymbol_case
	case *serverReflectionRequest_FileContainingExtension:
		return ServerReflectionRequest_FileContainingExtension_case
	case *serverReflectionRequest_AllExtensionNumbersOfType:
		return ServerReflectionRequest_AllExtensionNumbersOfType_case
	case *serverReflectionRequest_ListServices:
		return ServerReflectionRequest_ListServices_case
	default:
		return ServerReflectionRequest_MessageRequest_not_set_case
	}
}

type ServerReflectionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Host string
	// To use reflection service, the client should set one of the following
	// fields in message_request. The server distinguishes requests by their
	// defined field and then handles them using corresponding methods.

	// Fields of oneof xxx_hidden_MessageRequest:
	// Find a proto file by the file name.
	FileByFilename *string
	// Find the proto file that declares the given fully-qualified symbol name.
	// This field should be a fully-qualified symbol name
	// (e.g. <package>.<service>[.<method>] or <package>.<type>).
	FileContainingSymbol *string
	// Find the proto file which defines an extension extending the given
	// message type with the given field number.
	FileContainingExtension *ExtensionRequest
	// Finds the tag numbers used by all known extensions of the given message
	// type, and appends them to ExtensionNumberResponse in an undefined order.
	// Its corresponding method is best-effort: it's not guaranteed that the
	// reflection service will implement this method, and it's not guaranteed
	// that this method will provide all extensions. Returns
	// StatusCode::UNIMPLEMENTED if it's not implemented.
	// This field should be a fully-qualified type name. The format is
	// <package>.<type>
	AllExtensionNumbersOfType *string
	// List the full names of registered services. The content will not be
	// checked.
	ListServices *string
	// -- end of xxx_hidden_MessageRequest
}

func (b0 ServerReflectionRequest_builder) Build() *ServerReflectionRequest {
	m0 := &ServerReflectionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Host = b.Host
	if b.FileByFilename != nil {
		x.xxx_hidden_MessageRequest = &serverReflectionRequest_FileByFilename{*b.FileByFilename}
	}
	if b.FileContainingSymbol != nil {
		x.xxx_hidden_MessageRequest = &serverReflectionRequest_FileContainingSymbol{*b.FileContainingSymbol}
	}
	if b.FileContainingExtension != nil {
		x.xxx_hidden_MessageRequest = &serverReflectionRequest_FileContainingExtension{b.FileContainingExtension}
	}
	if b.AllExtensionNumbersOfType != nil {
		x.xxx_hidden_MessageRequest = &serverReflectionRequest_AllExtensionNumbersOfType{*b.AllExtensionNumbersOfType}
	}
	if b.ListServices != nil {
		x.xxx_hidden_MessageRequest = &serverReflectionRequest_ListServices{*b.ListServices}
	}
	return m0
}

type case_ServerReflectionRequest_MessageRequest protoreflect.FieldNumber

func (x case_ServerReflectionRequest_MessageRequest) String() string {
	md := file_grpc_reflection_v1_reflection_proto_msgTypes[0].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isServerReflectionRequest_MessageRequest interface {
	isServerReflectionRequest_MessageRequest()
}

type serverReflectionRequest_FileByFilename struct {
	// Find a proto file by the file name.
	FileByFilename string `protobuf:"bytes,3,opt,name=file_by_filename,json=fileByFilename,proto3,oneof"`
}

type serverReflectionRequest_FileContainingSymbol struct {
	// Find the proto file that declares the given fully-qualified symbol name.
	// This field should be a fully-qualified symbol name
	// (e.g. <package>.<service>[.<method>] or <package>.<type>).
	FileContainingSymbol string `protobuf:"bytes,4,opt,name=file_containing_symbol,json=fileContainingSymbol,proto3,oneof"`
}

type serverReflectionRequest_FileContainingExtension struct {
	// Find the proto file which defines an extension extending the given
	// message type with the given field number.
	FileContainingExtension *ExtensionRequest `protobuf:"bytes,5,opt,name=file_containing_extension,json=fileContainingExtension,proto3,oneof"`
}

type serverReflectionRequest_AllExtensionNumbersOfType struct {
	// Finds the tag numbers used by all known extensions of the given message
	// type, and appends them to ExtensionNumberResponse in an undefined order.
	// Its corresponding method is best-effort: it's not guaranteed that the
	// reflection service will implement this method, and it's not guaranteed
	// that this method will provide all extensions. Returns
	// StatusCode::UNIMPLEMENTED if it's not implemented.
	// This field should be a fully-qualified type name. The format is
	// <package>.<type>
	AllExtensionNumbersOfType string `protobuf:"bytes,6,opt,name=all_extension_numbers_of_type,json=allExtensionNumbersOfType,proto3,oneof"`
}

type serverReflectionRequest_ListServices struct {
	// List the full names of registered services. The content will not be
	// checked.
	ListServices string `protobuf:"bytes,7,opt,name=list_services,json=listServices,proto3,oneof"`
}

func (*serverReflectionRequest_FileByFilename) isServerReflectionRequest_MessageRequest() {}

func (*serverReflectionRequest_FileContainingSymbol) isServerReflectionRequest_MessageRequest() {}

func (*serverReflectionRequest_FileContainingExtension) isServerReflectionRequest_MessageRequest() {}

func (*serverReflectionRequest_AllExtensionNumbersOfType) isServerReflectionRequest_MessageRequest() {
}

func (*serverReflectionRequest_ListServices) isServerReflectionRequest_MessageRequest() {}

// The type name and extension number sent by the client when requesting
// file_containing_extension.
type ExtensionRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ContainingType  string                 `protobuf:"bytes,1,opt,name=containing_type,json=containingType,proto3"`
	xxx_hidden_ExtensionNumber int32                  `protobuf:"varint,2,opt,name=extension_number,json=extensionNumber,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ExtensionRequest) Reset() {
	*x = ExtensionRequest{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionRequest) ProtoMessage() {}

func (x *ExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ExtensionRequest) GetContainingType() string {
	if x != nil {
		return x.xxx_hidden_ContainingType
	}
	return ""
}

func (x *ExtensionRequest) GetExtensionNumber() int32 {
	if x != nil {
		return x.xxx_hidden_ExtensionNumber
	}
	return 0
}

func (x *ExtensionRequest) SetContainingType(v string) {
	x.xxx_hidden_ContainingType = v
}

func (x *ExtensionRequest) SetExtensionNumber(v int32) {
	x.xxx_hidden_ExtensionNumber = v
}

type ExtensionRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fully-qualified type name. The format should be <package>.<type>
	ContainingType  string
	ExtensionNumber int32
}

func (b0 ExtensionRequest_builder) Build() *ExtensionRequest {
	m0 := &ExtensionRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ContainingType = b.ContainingType
	x.xxx_hidden_ExtensionNumber = b.ExtensionNumber
	return m0
}

// The message sent by the server to answer ServerReflectionInfo method.
type ServerReflectionResponse struct {
	state                      protoimpl.MessageState                     `protogen:"opaque.v1"`
	xxx_hidden_ValidHost       string                                     `protobuf:"bytes,1,opt,name=valid_host,json=validHost,proto3"`
	xxx_hidden_OriginalRequest *ServerReflectionRequest                   `protobuf:"bytes,2,opt,name=original_request,json=originalRequest,proto3"`
	xxx_hidden_MessageResponse isServerReflectionResponse_MessageResponse `protobuf_oneof:"message_response"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ServerReflectionResponse) Reset() {
	*x = ServerReflectionResponse{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerReflectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerReflectionResponse) ProtoMessage() {}

func (x *ServerReflectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ServerReflectionResponse) GetValidHost() string {
	if x != nil {
		return x.xxx_hidden_ValidHost
	}
	return ""
}

func (x *ServerReflectionResponse) GetOriginalRequest() *ServerReflectionRequest {
	if x != nil {
		return x.xxx_hidden_OriginalRequest
	}
	return nil
}

func (x *ServerReflectionResponse) GetFileDescriptorResponse() *FileDescriptorResponse {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_FileDescriptorResponse); ok {
			return x.FileDescriptorResponse
		}
	}
	return nil
}

func (x *ServerReflectionResponse) GetAllExtensionNumbersResponse() *ExtensionNumberResponse {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_AllExtensionNumbersResponse); ok {
			return x.AllExtensionNumbersResponse
		}
	}
	return nil
}

func (x *ServerReflectionResponse) GetListServicesResponse() *ListServiceResponse {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_ListServicesResponse); ok {
			return x.ListServicesResponse
		}
	}
	return nil
}

func (x *ServerReflectionResponse) GetErrorResponse() *ErrorResponse {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_ErrorResponse); ok {
			return x.ErrorResponse
		}
	}
	return nil
}

func (x *ServerReflectionResponse) SetValidHost(v string) {
	x.xxx_hidden_ValidHost = v
}

func (x *ServerReflectionResponse) SetOriginalRequest(v *ServerReflectionRequest) {
	x.xxx_hidden_OriginalRequest = v
}

func (x *ServerReflectionResponse) SetFileDescriptorResponse(v *FileDescriptorResponse) {
	if v == nil {
		x.xxx_hidden_MessageResponse = nil
		return
	}
	x.xxx_hidden_MessageResponse = &serverReflectionResponse_FileDescriptorResponse{v}
}

func (x *ServerReflectionResponse) SetAllExtensionNumbersResponse(v *ExtensionNumberResponse) {
	if v == nil {
		x.xxx_hidden_MessageResponse = nil
		return
	}
	x.xxx_hidden_MessageResponse = &serverReflectionResponse_AllExtensionNumbersResponse{v}
}

func (x *ServerReflectionResponse) SetListServicesResponse(v *ListServiceResponse) {
	if v == nil {
		x.xxx_hidden_MessageResponse = nil
		return
	}
	x.xxx_hidden_MessageResponse = &serverReflectionResponse_ListServicesResponse{v}
}

func (x *ServerReflectionResponse) SetErrorResponse(v *ErrorResponse) {
	if v == nil {
		x.xxx_hidden_MessageResponse = nil
		return
	}
	x.xxx_hidden_MessageResponse = &serverReflectionResponse_ErrorResponse{v}
}

func (x *ServerReflectionResponse) HasOriginalRequest() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_OriginalRequest != nil
}

func (x *ServerReflectionResponse) HasMessageResponse() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_MessageResponse != nil
}

func (x *ServerReflectionResponse) HasFileDescriptorResponse() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_FileDescriptorResponse)
	return ok
}

func (x *ServerReflectionResponse) HasAllExtensionNumbersResponse() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_AllExtensionNumbersResponse)
	return ok
}

func (x *ServerReflectionResponse) HasListServicesResponse() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_ListServicesResponse)
	return ok
}

func (x *ServerReflectionResponse) HasErrorResponse() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_ErrorResponse)
	return ok
}

func (x *ServerReflectionResponse) ClearOriginalRequest() {
	x.xxx_hidden_OriginalRequest = nil
}

func (x *ServerReflectionResponse) ClearMessageResponse() {
	x.xxx_hidden_MessageResponse = nil
}

func (x *ServerReflectionResponse) ClearFileDescriptorResponse() {
	if _, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_FileDescriptorResponse); ok {
		x.xxx_hidden_MessageResponse = nil
	}
}

func (x *ServerReflectionResponse) ClearAllExtensionNumbersResponse() {
	if _, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_AllExtensionNumbersResponse); ok {
		x.xxx_hidden_MessageResponse = nil
	}
}

func (x *ServerReflectionResponse) ClearListServicesResponse() {
	if _, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_ListServicesResponse); ok {
		x.xxx_hidden_MessageResponse = nil
	}
}

func (x *ServerReflectionResponse) ClearErrorResponse() {
	if _, ok := x.xxx_hidden_MessageResponse.(*serverReflectionResponse_ErrorResponse); ok {
		x.xxx_hidden_MessageResponse = nil
	}
}

const ServerReflectionResponse_MessageResponse_not_set_case case_ServerReflectionResponse_MessageResponse = 0
const ServerReflectionResponse_FileDescriptorResponse_case case_ServerReflectionResponse_MessageResponse = 4
const ServerReflectionResponse_AllExtensionNumbersResponse_case case_ServerReflectionResponse_MessageResponse = 5
const ServerReflectionResponse_ListServicesResponse_case case_ServerReflectionResponse_MessageResponse = 6
const ServerReflectionResponse_ErrorResponse_case case_ServerReflectionResponse_MessageResponse = 7

func (x *ServerReflectionResponse) WhichMessageResponse() case_ServerReflectionResponse_MessageResponse {
	if x == nil {
		return ServerReflectionResponse_MessageResponse_not_set_case
	}
	switch x.xxx_hidden_MessageResponse.(type) {
	case *serverReflectionResponse_FileDescriptorResponse:
		return ServerReflectionResponse_FileDescriptorResponse_case
	case *serverReflectionResponse_AllExtensionNumbersResponse:
		return ServerReflectionResponse_AllExtensionNumbersResponse_case
	case *serverReflectionResponse_ListServicesResponse:
		return ServerReflectionResponse_ListServicesResponse_case
	case *serverReflectionResponse_ErrorResponse:
		return ServerReflectionResponse_ErrorResponse_case
	default:
		return ServerReflectionResponse_MessageResponse_not_set_case
	}
}

type ServerReflectionResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ValidHost       string
	OriginalRequest *ServerReflectionRequest
	// The server sets one of the following fields according to the message_request
	// in the request.

	// Fields of oneof xxx_hidden_MessageResponse:
	// This message is used to answer file_by_filename, file_containing_symbol,
	// file_containing_extension requests with transitive dependencies.
	// As the repeated label is not allowed in oneof fields, we use a
	// FileDescriptorResponse message to encapsulate the repeated fields.
	// The reflection service is allowed to avoid sending FileDescriptorProtos
	// that were previously sent in response to earlier requests in the stream.
	FileDescriptorResponse *FileDescriptorResponse
	// This message is used to answer all_extension_numbers_of_type requests.
	AllExtensionNumbersResponse *ExtensionNumberResponse
	// This message is used to answer list_services requests.
	ListServicesResponse *ListServiceResponse
	// This message is used when an error occurs.
	ErrorResponse *ErrorResponse
	// -- end of xxx_hidden_MessageResponse
}

func (b0 ServerReflectionResponse_builder) Build() *ServerReflectionResponse {
	m0 := &ServerReflectionResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ValidHost = b.ValidHost
	x.xxx_hidden_OriginalRequest = b.OriginalRequest
	if b.FileDescriptorResponse != nil {
		x.xxx_hidden_MessageResponse = &serverReflectionResponse_FileDescriptorResponse{b.FileDescriptorResponse}
	}
	if b.AllExtensionNumbersResponse != nil {
		x.xxx_hidden_MessageResponse = &serverReflectionResponse_AllExtensionNumbersResponse{b.AllExtensionNumbersResponse}
	}
	if b.ListServicesResponse != nil {
		x.xxx_hidden_MessageResponse = &serverReflectionResponse_ListServicesResponse{b.ListServicesResponse}
	}
	if b.ErrorResponse != nil {
		x.xxx_hidden_MessageResponse = &serverReflectionResponse_ErrorResponse{b.ErrorResponse}
	}
	return m0
}

type case_ServerReflectionResponse_MessageResponse protoreflect.FieldNumber

func (x case_ServerReflectionResponse_MessageResponse) String() string {
	md := file_grpc_reflection_v1_reflection_proto_msgTypes[2].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isServerReflectionResponse_MessageResponse interface {
	isServerReflectionResponse_MessageResponse()
}

type serverReflectionResponse_FileDescriptorResponse struct {
	// This message is used to answer file_by_filename, file_containing_symbol,
	// file_containing_extension requests with transitive dependencies.
	// As the repeated label is not allowed in oneof fields, we use a
	// FileDescriptorResponse message to encapsulate the repeated fields.
	// The reflection service is allowed to avoid sending FileDescriptorProtos
	// that were previously sent in response to earlier requests in the stream.
	FileDescriptorResponse *FileDescriptorResponse `protobuf:"bytes,4,opt,name=file_descriptor_response,json=fileDescriptorResponse,proto3,oneof"`
}

type serverReflectionResponse_AllExtensionNumbersResponse struct {
	// This message is used to answer all_extension_numbers_of_type requests.
	AllExtensionNumbersResponse *ExtensionNumberResponse `protobuf:"bytes,5,opt,name=all_extension_numbers_response,json=allExtensionNumbersResponse,proto3,oneof"`
}

type serverReflectionResponse_ListServicesResponse struct {
	// This message is used to answer list_services requests.
	ListServicesResponse *ListServiceResponse `protobuf:"bytes,6,opt,name=list_services_response,json=listServicesResponse,proto3,oneof"`
}

type serverReflectionResponse_ErrorResponse struct {
	// This message is used when an error occurs.
	ErrorResponse *ErrorResponse `protobuf:"bytes,7,opt,name=error_response,json=errorResponse,proto3,oneof"`
}

func (*serverReflectionResponse_FileDescriptorResponse) isServerReflectionResponse_MessageResponse() {
}

func (*serverReflectionResponse_AllExtensionNumbersResponse) isServerReflectionResponse_MessageResponse() {
}

func (*serverReflectionResponse_ListServicesResponse) isServerReflectionResponse_MessageResponse() {}

func (*serverReflectionResponse_ErrorResponse) isServerReflectionResponse_MessageResponse() {}

// Serialized FileDescriptorProto messages sent by the server answering
// a file_by_filename, file_containing_symbol, or file_containing_extension
// request.
type FileDescriptorResponse struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FileDescriptorProto [][]byte               `protobuf:"bytes,1,rep,name=file_descriptor_proto,json=fileDescriptorProto,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *FileDescriptorResponse) Reset() {
	*x = FileDescriptorResponse{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileDescriptorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileDescriptorResponse) ProtoMessage() {}

func (x *FileDescriptorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FileDescriptorResponse) GetFileDescriptorProto() [][]byte {
	if x != nil {
		return x.xxx_hidden_FileDescriptorProto
	}
	return nil
}

func (x *FileDescriptorResponse) SetFileDescriptorProto(v [][]byte) {
	x.xxx_hidden_FileDescriptorProto = v
}

type FileDescriptorResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Serialized FileDescriptorProto messages. We avoid taking a dependency on
	// descriptor.proto, which uses proto2 only features, by making them opaque
	// bytes instead.
	FileDescriptorProto [][]byte
}

func (b0 FileDescriptorResponse_builder) Build() *FileDescriptorResponse {
	m0 := &FileDescriptorResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FileDescriptorProto = b.FileDescriptorProto
	return m0
}

// A list of extension numbers sent by the server answering
// all_extension_numbers_of_type request.
type ExtensionNumberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_BaseTypeName    string                 `protobuf:"bytes,1,opt,name=base_type_name,json=baseTypeName,proto3"`
	xxx_hidden_ExtensionNumber []int32                `protobuf:"varint,2,rep,packed,name=extension_number,json=extensionNumber,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ExtensionNumberResponse) Reset() {
	*x = ExtensionNumberResponse{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionNumberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionNumberResponse) ProtoMessage() {}

func (x *ExtensionNumberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ExtensionNumberResponse) GetBaseTypeName() string {
	if x != nil {
		return x.xxx_hidden_BaseTypeName
	}
	return ""
}

func (x *ExtensionNumberResponse) GetExtensionNumber() []int32 {
	if x != nil {
		return x.xxx_hidden_ExtensionNumber
	}
	return nil
}

func (x *ExtensionNumberResponse) SetBaseTypeName(v string) {
	x.xxx_hidden_BaseTypeName = v
}

func (x *ExtensionNumberResponse) SetExtensionNumber(v []int32) {
	x.xxx_hidden_ExtensionNumber = v
}

type ExtensionNumberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Full name of the base type, including the package name. The format
	// is <package>.<type>
	BaseTypeName    string
	ExtensionNumber []int32
}

func (b0 ExtensionNumberResponse_builder) Build() *ExtensionNumberResponse {
	m0 := &ExtensionNumberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_BaseTypeName = b.BaseTypeName
	x.xxx_hidden_ExtensionNumber = b.ExtensionNumber
	return m0
}

// A list of ServiceResponse sent by the server answering list_services request.
type ListServiceResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Service *[]*ServiceResponse    `protobuf:"bytes,1,rep,name=service,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ListServiceResponse) Reset() {
	*x = ListServiceResponse{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceResponse) ProtoMessage() {}

func (x *ListServiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListServiceResponse) GetService() []*ServiceResponse {
	if x != nil {
		if x.xxx_hidden_Service != nil {
			return *x.xxx_hidden_Service
		}
	}
	return nil
}

func (x *ListServiceResponse) SetService(v []*ServiceResponse) {
	x.xxx_hidden_Service = &v
}

type ListServiceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The information of each service may be expanded in the future, so we use
	// ServiceResponse message to encapsulate it.
	Service []*ServiceResponse
}

func (b0 ListServiceResponse_builder) Build() *ListServiceResponse {
	m0 := &ListServiceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Service = &b.Service
	return m0
}

// The information of a single service used by ListServiceResponse to answer
// list_services request.
type ServiceResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ServiceResponse) Reset() {
	*x = ServiceResponse{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResponse) ProtoMessage() {}

func (x *ServiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ServiceResponse) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *ServiceResponse) SetName(v string) {
	x.xxx_hidden_Name = v
}

type ServiceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Full name of a registered service, including its package name. The format
	// is <package>.<service>
	Name string
}

func (b0 ServiceResponse_builder) Build() *ServiceResponse {
	m0 := &ServiceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	return m0
}

// The error code and error message sent by the server when an error occurs.
type ErrorResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ErrorCode    int32                  `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3"`
	xxx_hidden_ErrorMessage string                 `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ErrorResponse) Reset() {
	*x = ErrorResponse{}
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ErrorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorResponse) ProtoMessage() {}

func (x *ErrorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_reflection_v1_reflection_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ErrorResponse) GetErrorCode() int32 {
	if x != nil {
		return x.xxx_hidden_ErrorCode
	}
	return 0
}

func (x *ErrorResponse) GetErrorMessage() string {
	if x != nil {
		return x.xxx_hidden_ErrorMessage
	}
	return ""
}

func (x *ErrorResponse) SetErrorCode(v int32) {
	x.xxx_hidden_ErrorCode = v
}

func (x *ErrorResponse) SetErrorMessage(v string) {
	x.xxx_hidden_ErrorMessage = v
}

type ErrorResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// This field uses the error codes defined in grpc::StatusCode.
	ErrorCode    int32
	ErrorMessage string
}

func (b0 ErrorResponse_builder) Build() *ErrorResponse {
	m0 := &ErrorResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ErrorCode = b.ErrorCode
	x.xxx_hidden_ErrorMessage = b.ErrorMessage
	return m0
}

var File_grpc_reflection_v1_reflection_proto protoreflect.FileDescriptor

const file_grpc_reflection_v1_reflection_proto_rawDesc = "" +
	"\n" +
	"#grpc/reflection/v1/reflection.proto\x12\x12grpc.reflection.v1\"\xf3\x02\n" +
	"\x17ServerReflectionRequest\x12\x12\n" +
	"\x04host\x18\x01 \x01(\tR\x04host\x12*\n" +
	"\x10file_by_filename\x18\x03 \x01(\tH\x00R\x0efileByFilename\x126\n" +
	"\x16file_containing_symbol\x18\x04 \x01(\tH\x00R\x14fileContainingSymbol\x12b\n" +
	"\x19file_containing_extension\x18\x05 \x01(\v2$.grpc.reflection.v1.ExtensionRequestH\x00R\x17fileContainingExtension\x12B\n" +
	"\x1dall_extension_numbers_of_type\x18\x06 \x01(\tH\x00R\x19allExtensionNumbersOfType\x12%\n" +
	"\rlist_services\x18\a \x01(\tH\x00R\flistServicesB\x11\n" +
	"\x0fmessage_request\"f\n" +
	"\x10ExtensionRequest\x12'\n" +
	"\x0fcontaining_type\x18\x01 \x01(\tR\x0econtainingType\x12)\n" +
	"\x10extension_number\x18\x02 \x01(\x05R\x0fextensionNumber\"\xae\x04\n" +
	"\x18ServerReflectionResponse\x12\x1d\n" +
	"\n" +
	"valid_host\x18\x01 \x01(\tR\tvalidHost\x12V\n" +
	"\x10original_request\x18\x02 \x01(\v2+.grpc.reflection.v1.ServerReflectionRequestR\x0foriginalRequest\x12f\n" +
	"\x18file_descriptor_response\x18\x04 \x01(\v2*.grpc.reflection.v1.FileDescriptorResponseH\x00R\x16fileDescriptorResponse\x12r\n" +
	"\x1eall_extension_numbers_response\x18\x05 \x01(\v2+.grpc.reflection.v1.ExtensionNumberResponseH\x00R\x1ballExtensionNumbersResponse\x12_\n" +
	"\x16list_services_response\x18\x06 \x01(\v2'.grpc.reflection.v1.ListServiceResponseH\x00R\x14listServicesResponse\x12J\n" +
	"\x0eerror_response\x18\a \x01(\v2!.grpc.reflection.v1.ErrorResponseH\x00R\rerrorResponseB\x12\n" +
	"\x10message_response\"L\n" +
	"\x16FileDescriptorResponse\x122\n" +
	"\x15file_descriptor_proto\x18\x01 \x03(\fR\x13fileDescriptorProto\"j\n" +
	"\x17ExtensionNumberResponse\x12$\n" +
	"\x0ebase_type_name\x18\x01 \x01(\tR\fbaseTypeName\x12)\n" +
	"\x10extension_number\x18\x02 \x03(\x05R\x0fextensionNumber\"T\n" +
	"\x13ListServiceResponse\x12=\n" +
	"\aservice\x18\x01 \x03(\v2#.grpc.reflection.v1.ServiceResponseR\aservice\"%\n" +
	"\x0fServiceResponse\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"S\n" +
	"\rErrorResponse\x12\x1d\n" +
	"\n" +
	"error_code\x18\x01 \x01(\x05R\terrorCode\x12#\n" +
	"\rerror_message\x18\x02 \x01(\tR\ferrorMessage2\x89\x01\n" +
	"\x10ServerReflection\x12u\n" +
	"\x14ServerReflectionInfo\x12+.grpc.reflection.v1.ServerReflectionRequest\x1a,.grpc.reflection.v1.ServerReflectionResponse(\x010\x01B\xe1\x01\n" +
	"\x16com.grpc.reflection.v1B\x0fReflectionProtoP\x01ZLgithub.com/bufbuild/buf/private/gen/proto/go/grpc/reflection/v1;reflectionv1\xa2\x02\x03GRX\xaa\x02\x12Grpc.Reflection.V1\xca\x02\x12Grpc\\Reflection\\V1\xe2\x02\x1eGrpc\\Reflection\\V1\\GPBMetadata\xea\x02\x14Grpc::Reflection::V1b\x06proto3"

var file_grpc_reflection_v1_reflection_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_grpc_reflection_v1_reflection_proto_goTypes = []any{
	(*ServerReflectionRequest)(nil),  // 0: grpc.reflection.v1.ServerReflectionRequest
	(*ExtensionRequest)(nil),         // 1: grpc.reflection.v1.ExtensionRequest
	(*ServerReflectionResponse)(nil), // 2: grpc.reflection.v1.ServerReflectionResponse
	(*FileDescriptorResponse)(nil),   // 3: grpc.reflection.v1.FileDescriptorResponse
	(*ExtensionNumberResponse)(nil),  // 4: grpc.reflection.v1.ExtensionNumberResponse
	(*ListServiceResponse)(nil),      // 5: grpc.reflection.v1.ListServiceResponse
	(*ServiceResponse)(nil),          // 6: grpc.reflection.v1.ServiceResponse
	(*ErrorResponse)(nil),            // 7: grpc.reflection.v1.ErrorResponse
}
var file_grpc_reflection_v1_reflection_proto_depIdxs = []int32{
	1, // 0: grpc.reflection.v1.ServerReflectionRequest.file_containing_extension:type_name -> grpc.reflection.v1.ExtensionRequest
	0, // 1: grpc.reflection.v1.ServerReflectionResponse.original_request:type_name -> grpc.reflection.v1.ServerReflectionRequest
	3, // 2: grpc.reflection.v1.ServerReflectionResponse.file_descriptor_response:type_name -> grpc.reflection.v1.FileDescriptorResponse
	4, // 3: grpc.reflection.v1.ServerReflectionResponse.all_extension_numbers_response:type_name -> grpc.reflection.v1.ExtensionNumberResponse
	5, // 4: grpc.reflection.v1.ServerReflectionResponse.list_services_response:type_name -> grpc.reflection.v1.ListServiceResponse
	7, // 5: grpc.reflection.v1.ServerReflectionResponse.error_response:type_name -> grpc.reflection.v1.ErrorResponse
	6, // 6: grpc.reflection.v1.ListServiceResponse.service:type_name -> grpc.reflection.v1.ServiceResponse
	0, // 7: grpc.reflection.v1.ServerReflection.ServerReflectionInfo:input_type -> grpc.reflection.v1.ServerReflectionRequest
	2, // 8: grpc.reflection.v1.ServerReflection.ServerReflectionInfo:output_type -> grpc.reflection.v1.ServerReflectionResponse
	8, // [8:9] is the sub-list for method output_type
	7, // [7:8] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_grpc_reflection_v1_reflection_proto_init() }
func file_grpc_reflection_v1_reflection_proto_init() {
	if File_grpc_reflection_v1_reflection_proto != nil {
		return
	}
	file_grpc_reflection_v1_reflection_proto_msgTypes[0].OneofWrappers = []any{
		(*serverReflectionRequest_FileByFilename)(nil),
		(*serverReflectionRequest_FileContainingSymbol)(nil),
		(*serverReflectionRequest_FileContainingExtension)(nil),
		(*serverReflectionRequest_AllExtensionNumbersOfType)(nil),
		(*serverReflectionRequest_ListServices)(nil),
	}
	file_grpc_reflection_v1_reflection_proto_msgTypes[2].OneofWrappers = []any{
		(*serverReflectionResponse_FileDescriptorResponse)(nil),
		(*serverReflectionResponse_AllExtensionNumbersResponse)(nil),
		(*serverReflectionResponse_ListServicesResponse)(nil),
		(*serverReflectionResponse_ErrorResponse)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_grpc_reflection_v1_reflection_proto_rawDesc), len(file_grpc_reflection_v1_reflection_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_grpc_reflection_v1_reflection_proto_goTypes,
		DependencyIndexes: file_grpc_reflection_v1_reflection_proto_depIdxs,
		MessageInfos:      file_grpc_reflection_v1_reflection_proto_msgTypes,
	}.Build()
	File_grpc_reflection_v1_reflection_proto = out.File
	file_grpc_reflection_v1_reflection_proto_goTypes = nil
	file_grpc_reflection_v1_reflection_proto_depIdxs = nil
}
